/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.hk2.utilities.general;

import fish.payara.arquillian.hk2.utilities.general.internal.MessageInterpolatorImpl;
import fish.payara.arquillian.validation.Path;
import fish.payara.arquillian.validation.TraversableResolver;
import fish.payara.arquillian.validation.Validation;
import fish.payara.arquillian.validation.Validator;
import fish.payara.arquillian.validation.ValidatorContext;
import fish.payara.arquillian.validation.ValidatorFactory;
import java.lang.annotation.ElementType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.hibernate.validator.HibernateValidator;

public class ValidatorUtilities {
    private static final TraversableResolver TRAVERSABLE_RESOLVER = new TraversableResolver(){

        @Override
        public boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
            return true;
        }

        @Override
        public boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
            return true;
        }
    };
    private static Validator validator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Validator initializeValidator() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(HibernateValidator.class.getClassLoader());
            ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
            ValidatorContext validatorContext = validatorFactory.usingContext();
            validatorContext.messageInterpolator(new MessageInterpolatorImpl());
            Validator validator = validatorContext.traversableResolver(TRAVERSABLE_RESOLVER).getValidator();
            return validator;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public static synchronized Validator getValidator() {
        if (validator == null) {
            validator = AccessController.doPrivileged(new PrivilegedAction<Validator>(){

                @Override
                public Validator run() {
                    return ValidatorUtilities.initializeValidator();
                }
            });
        }
        if (validator == null) {
            throw new IllegalStateException("Could not find a javax.validator");
        }
        return validator;
    }
}

