/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.jersey.message.filtering;

import fish.payara.arquillian.annotation.Priority;
import fish.payara.arquillian.inject.Singleton;
import fish.payara.arquillian.jersey.internal.util.ReflectionHelper;
import fish.payara.arquillian.jersey.message.filtering.spi.AbstractEntityProcessor;
import fish.payara.arquillian.jersey.message.filtering.spi.EntityGraph;
import fish.payara.arquillian.jersey.message.filtering.spi.EntityProcessor;
import fish.payara.arquillian.jersey.message.filtering.spi.EntityProcessorContext;
import fish.payara.arquillian.jersey.message.filtering.spi.FilteringHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

@Singleton
@Priority(value=2147482647)
final class DefaultEntityProcessor
extends AbstractEntityProcessor {
    DefaultEntityProcessor() {
    }

    @Override
    public EntityProcessor.Result process(EntityProcessorContext context) {
        switch (context.getType()) {
            case CLASS_READER: 
            case CLASS_WRITER: {
                EntityGraph graph = context.getEntityGraph();
                if (graph.getFilteringScopes().isEmpty()) {
                    graph.addFilteringScopes(FilteringHelper.getDefaultFilteringScope());
                }
                return EntityProcessor.Result.APPLY;
            }
            case PROPERTY_READER: 
            case PROPERTY_WRITER: {
                Field field = context.getField();
                this.process(context.getEntityGraph(), field.getName(), field.getGenericType());
                return EntityProcessor.Result.APPLY;
            }
            case METHOD_READER: 
            case METHOD_WRITER: {
                Method method = context.getMethod();
                this.process(context.getEntityGraph(), ReflectionHelper.getPropertyName(method), method.getGenericReturnType());
                return EntityProcessor.Result.APPLY;
            }
        }
        return EntityProcessor.Result.SKIP;
    }

    private void process(EntityGraph graph, String fieldName, Type fieldType) {
        if (!graph.presentInScopes(fieldName)) {
            this.addFilteringScopes(fieldName, FilteringHelper.getEntityClass(fieldType), graph.getClassFilteringScopes(), graph);
        }
    }
}

