/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.jersey.message.filtering;

import fish.payara.arquillian.annotation.Priority;
import fish.payara.arquillian.inject.Inject;
import fish.payara.arquillian.inject.Provider;
import fish.payara.arquillian.inject.Singleton;
import fish.payara.arquillian.jersey.internal.inject.InjectionManager;
import fish.payara.arquillian.jersey.message.filtering.CommonScopeProvider;
import fish.payara.arquillian.jersey.server.ExtendedUriInfo;
import fish.payara.arquillian.jersey.server.model.Invocable;
import fish.payara.arquillian.jersey.server.model.ResourceMethod;
import fish.payara.arquillian.ws.rs.ConstrainedTo;
import fish.payara.arquillian.ws.rs.RuntimeType;
import fish.payara.arquillian.ws.rs.core.Configuration;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@Singleton
@Priority(value=4200)
@ConstrainedTo(value=RuntimeType.SERVER)
class ServerScopeProvider
extends CommonScopeProvider {
    @Inject
    private Provider<ExtendedUriInfo> uriInfoProvider;
    private final ConcurrentMap<String, Set<String>> uriToContexts = new ConcurrentHashMap<String, Set<String>>();

    @Inject
    public ServerScopeProvider(Configuration config, InjectionManager injectionManager) {
        super(config, injectionManager);
    }

    @Override
    public Set<String> getFilteringScopes(Annotation[] entityAnnotations, boolean defaultIfNotFound) {
        Set<String> filteringScope = super.getFilteringScopes(entityAnnotations, false);
        if (filteringScope.isEmpty()) {
            ExtendedUriInfo uriInfo = this.uriInfoProvider.get();
            String path = uriInfo.getPath();
            if (this.uriToContexts.containsKey(path)) {
                return (Set)this.uriToContexts.get(path);
            }
            for (ResourceMethod method : ServerScopeProvider.getMatchedMethods(uriInfo)) {
                Invocable invocable = method.getInvocable();
                this.mergeFilteringScopes(filteringScope, this.getFilteringScopes(invocable.getHandlingMethod(), invocable.getHandler().getHandlerClass()));
                if (filteringScope.isEmpty()) continue;
                this.uriToContexts.putIfAbsent(path, filteringScope);
                return filteringScope;
            }
        }
        return this.returnFilteringScopes(filteringScope, defaultIfNotFound);
    }

    protected Set<String> getFilteringScopes(Method resourceMethod, Class<?> resourceClass) {
        Set<String> scope = this.getFilteringScopes(resourceMethod.getAnnotations());
        if (scope.isEmpty()) {
            scope = this.getFilteringScopes(resourceClass.getAnnotations());
        }
        return scope;
    }

    private static List<ResourceMethod> getMatchedMethods(ExtendedUriInfo uriInfo) {
        List<ResourceMethod> matchedResourceLocators = uriInfo.getMatchedResourceLocators();
        ArrayList<ResourceMethod> methods = new ArrayList<ResourceMethod>(1 + matchedResourceLocators.size());
        methods.add(uriInfo.getMatchedResourceMethod());
        methods.addAll(matchedResourceLocators);
        return methods;
    }
}

