/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.jersey.message.internal;

import fish.payara.arquillian.inject.Singleton;
import fish.payara.arquillian.jersey.internal.LocalizationMessages;
import fish.payara.arquillian.jersey.message.internal.HttpDateFormat;
import fish.payara.arquillian.jersey.message.internal.HttpHeaderReader;
import fish.payara.arquillian.jersey.message.internal.Utils;
import fish.payara.arquillian.jersey.spi.HeaderDelegateProvider;
import java.text.ParseException;
import java.util.Date;

@Singleton
public class DateProvider
implements HeaderDelegateProvider<Date> {
    @Override
    public boolean supports(Class<?> type) {
        return Date.class.isAssignableFrom(type);
    }

    @Override
    public String toString(Date header) {
        Utils.throwIllegalArgumentExceptionIfNull(header, LocalizationMessages.DATE_IS_NULL());
        return HttpDateFormat.getPreferredDateFormat().format(header);
    }

    @Override
    public Date fromString(String header) {
        Utils.throwIllegalArgumentExceptionIfNull(header, LocalizationMessages.DATE_IS_NULL());
        try {
            return HttpHeaderReader.readDate(header);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Error parsing date '" + header + "'", ex);
        }
    }
}

