/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.jersey.message.internal;

import fish.payara.arquillian.inject.Singleton;
import fish.payara.arquillian.jersey.internal.LocalizationMessages;
import fish.payara.arquillian.jersey.message.internal.LanguageTag;
import fish.payara.arquillian.jersey.message.internal.Utils;
import fish.payara.arquillian.jersey.spi.HeaderDelegateProvider;
import java.text.ParseException;
import java.util.Locale;

@Singleton
public class LocaleProvider
implements HeaderDelegateProvider<Locale> {
    @Override
    public boolean supports(Class<?> type) {
        return Locale.class.isAssignableFrom(type);
    }

    @Override
    public String toString(Locale header) {
        Utils.throwIllegalArgumentExceptionIfNull(header, LocalizationMessages.LOCALE_IS_NULL());
        if (header.getCountry().length() == 0) {
            return header.getLanguage();
        }
        return header.getLanguage() + '-' + header.getCountry();
    }

    @Override
    public Locale fromString(String header) {
        Utils.throwIllegalArgumentExceptionIfNull(header, LocalizationMessages.LOCALE_IS_NULL());
        try {
            LanguageTag lt = new LanguageTag(header);
            return lt.getAsLocale();
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Error parsing date '" + header + "'", ex);
        }
    }
}

