/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.jersey.server.internal;

import fish.payara.arquillian.annotation.Priority;
import fish.payara.arquillian.inject.Singleton;
import fish.payara.arquillian.jersey.internal.inject.AbstractBinder;
import fish.payara.arquillian.jersey.internal.inject.ClassBinding;
import fish.payara.arquillian.jersey.message.internal.MessageBodyProviderNotFoundException;
import fish.payara.arquillian.jersey.server.internal.process.MappableException;
import fish.payara.arquillian.ws.rs.InternalServerErrorException;
import fish.payara.arquillian.ws.rs.WebApplicationException;
import fish.payara.arquillian.ws.rs.ext.ReaderInterceptor;
import fish.payara.arquillian.ws.rs.ext.ReaderInterceptorContext;
import fish.payara.arquillian.ws.rs.ext.WriterInterceptor;
import fish.payara.arquillian.ws.rs.ext.WriterInterceptorContext;
import java.io.IOException;

@Priority(value=10)
@Singleton
public class MappableExceptionWrapperInterceptor
implements ReaderInterceptor,
WriterInterceptor {
    @Override
    public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
        try {
            return context.proceed();
        }
        catch (MessageBodyProviderNotFoundException | MappableException | WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MappableException(e);
        }
    }

    @Override
    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        try {
            context.proceed();
        }
        catch (MappableException | WebApplicationException e) {
            throw e;
        }
        catch (MessageBodyProviderNotFoundException nfe) {
            throw new InternalServerErrorException(nfe);
        }
        catch (Exception e) {
            throw new MappableException(e);
        }
    }

    public static class Binder
    extends AbstractBinder {
        @Override
        protected void configure() {
            ((ClassBinding)((ClassBinding)this.bind(MappableExceptionWrapperInterceptor.class).to(ReaderInterceptor.class)).to(WriterInterceptor.class)).in(Singleton.class);
        }
    }
}

