/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.jersey.server.internal.inject;

import fish.payara.arquillian.inject.Singleton;
import fish.payara.arquillian.jersey.internal.inject.Binding;
import fish.payara.arquillian.jersey.internal.inject.Bindings;
import fish.payara.arquillian.jersey.internal.inject.ContextInjectionResolver;
import fish.payara.arquillian.jersey.internal.inject.ForeignDescriptor;
import fish.payara.arquillian.jersey.internal.inject.Injectee;
import fish.payara.arquillian.jersey.internal.inject.InjecteeImpl;
import fish.payara.arquillian.jersey.internal.util.collection.Cache;
import fish.payara.arquillian.jersey.internal.util.collection.LazyValue;
import fish.payara.arquillian.jersey.model.Parameter;
import fish.payara.arquillian.jersey.process.internal.RequestScoped;
import fish.payara.arquillian.jersey.server.ContainerRequest;
import fish.payara.arquillian.jersey.server.model.Parameter;
import fish.payara.arquillian.jersey.server.spi.internal.ValueParamProvider;
import java.lang.reflect.ParameterizedType;
import java.util.function.Function;

@Singleton
class DelegatedInjectionValueParamProvider
implements ValueParamProvider {
    private final LazyValue<ContextInjectionResolver> resolver;
    private final Function<Binding, ForeignDescriptor> foreignDescriptorFactory;
    private final Cache<Parameter, ForeignDescriptor> descriptorCache = new Cache<Parameter, ForeignDescriptor>(parameter -> {
        Class<?> rawType = parameter.getRawType();
        if (rawType.isInterface() && !(parameter.getType() instanceof ParameterizedType)) {
            return this.createDescriptor(rawType);
        }
        return null;
    });

    public DelegatedInjectionValueParamProvider(LazyValue<ContextInjectionResolver> resolver, Function<Binding, ForeignDescriptor> foreignDescriptorFactory) {
        this.resolver = resolver;
        this.foreignDescriptorFactory = foreignDescriptorFactory;
    }

    @Override
    public Function<ContainerRequest, ?> getValueProvider(Parameter parameter) {
        Parameter.Source paramSource = parameter.getSource();
        if (paramSource == Parameter.Source.CONTEXT) {
            return containerRequest -> ((ContextInjectionResolver)this.resolver.get()).resolve(this.getInjectee(parameter));
        }
        return null;
    }

    @Override
    public ValueParamProvider.PriorityType getPriority() {
        return ValueParamProvider.Priority.LOW;
    }

    private Injectee getInjectee(Parameter parameter) {
        InjecteeImpl injectee = new InjecteeImpl();
        injectee.setRequiredType(parameter.getType());
        injectee.setInjecteeClass(parameter.getRawType());
        ForeignDescriptor proxyDescriptor = this.descriptorCache.apply(parameter);
        if (proxyDescriptor != null) {
            injectee.setInjecteeDescriptor(proxyDescriptor);
        }
        return injectee;
    }

    private ForeignDescriptor createDescriptor(Class<?> clazz) {
        return this.foreignDescriptorFactory.apply((Binding)Bindings.serviceAsContract(clazz).in(RequestScoped.class));
    }
}

