/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.jersey.server.internal.monitoring;

import fish.payara.arquillian.annotation.Priority;
import fish.payara.arquillian.inject.Inject;
import fish.payara.arquillian.inject.Provider;
import fish.payara.arquillian.jersey.internal.util.collection.Ref;
import fish.payara.arquillian.jersey.server.internal.monitoring.ApplicationInfoImpl;
import fish.payara.arquillian.jersey.server.monitoring.ApplicationEvent;
import fish.payara.arquillian.jersey.server.monitoring.ApplicationEventListener;
import fish.payara.arquillian.jersey.server.monitoring.ApplicationInfo;
import fish.payara.arquillian.jersey.server.monitoring.RequestEvent;
import fish.payara.arquillian.jersey.server.monitoring.RequestEventListener;
import java.util.Date;

@Priority(value=1000)
public final class ApplicationInfoListener
implements ApplicationEventListener {
    public static final int PRIORITY = 1000;
    @Inject
    private Provider<Ref<ApplicationInfo>> applicationInfoRefProvider;

    @Override
    public RequestEventListener onRequest(RequestEvent requestEvent) {
        return null;
    }

    @Override
    public void onEvent(ApplicationEvent event) {
        ApplicationEvent.Type type = event.getType();
        switch (type) {
            case RELOAD_FINISHED: 
            case INITIALIZATION_FINISHED: {
                this.processApplicationStatistics(event);
            }
        }
    }

    private void processApplicationStatistics(ApplicationEvent event) {
        long now = System.currentTimeMillis();
        ApplicationInfoImpl applicationInfo = new ApplicationInfoImpl(event.getResourceConfig(), new Date(now), event.getRegisteredClasses(), event.getRegisteredInstances(), event.getProviders());
        this.applicationInfoRefProvider.get().set(applicationInfo);
    }
}

