/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.jersey.server.model;

import fish.payara.arquillian.jersey.model.ContractProvider;
import fish.payara.arquillian.jersey.model.internal.CommonConfig;
import fish.payara.arquillian.jersey.model.internal.ComponentBag;
import fish.payara.arquillian.jersey.process.Inflector;
import fish.payara.arquillian.jersey.server.internal.LocalizationMessages;
import fish.payara.arquillian.ws.rs.RuntimeType;
import fish.payara.arquillian.ws.rs.container.ContainerRequestFilter;
import fish.payara.arquillian.ws.rs.container.ContainerResponseFilter;
import fish.payara.arquillian.ws.rs.ext.ReaderInterceptor;
import fish.payara.arquillian.ws.rs.ext.WriterInterceptor;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

class ResourceMethodConfig
extends CommonConfig {
    private static final Logger LOGGER = Logger.getLogger(ResourceMethodConfig.class.getName());
    private static final Set<Class<?>> allowedContracts;

    ResourceMethodConfig(Map<String, Object> properties) {
        super(RuntimeType.SERVER, ComponentBag.EXCLUDE_EMPTY);
        this.setProperties(properties);
    }

    @Override
    protected Inflector<ContractProvider.Builder, ContractProvider> getModelEnhancer(final Class<?> providerClass) {
        return new Inflector<ContractProvider.Builder, ContractProvider>(){

            @Override
            public ContractProvider apply(ContractProvider.Builder builder) {
                Iterator<Class<?>> it = builder.getContracts().keySet().iterator();
                while (it.hasNext()) {
                    Class<?> contract = it.next();
                    if (allowedContracts.contains(contract)) continue;
                    LOGGER.warning(LocalizationMessages.CONTRACT_CANNOT_BE_BOUND_TO_RESOURCE_METHOD(contract, providerClass));
                    it.remove();
                }
                return builder.build();
            }
        };
    }

    static {
        Set tempSet = Collections.newSetFromMap(new IdentityHashMap());
        tempSet.add(ContainerRequestFilter.class);
        tempSet.add(ContainerResponseFilter.class);
        tempSet.add(ReaderInterceptor.class);
        tempSet.add(WriterInterceptor.class);
        allowedContracts = Collections.unmodifiableSet(tempSet);
    }
}

