/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.json.jaxrs;

import fish.payara.arquillian.annotation.PostConstruct;
import fish.payara.arquillian.javax.json.Json;
import fish.payara.arquillian.javax.json.JsonValue;
import fish.payara.arquillian.javax.json.JsonWriter;
import fish.payara.arquillian.javax.json.JsonWriterFactory;
import fish.payara.arquillian.ws.rs.Produces;
import fish.payara.arquillian.ws.rs.WebApplicationException;
import fish.payara.arquillian.ws.rs.core.Configuration;
import fish.payara.arquillian.ws.rs.core.Context;
import fish.payara.arquillian.ws.rs.core.MediaType;
import fish.payara.arquillian.ws.rs.core.MultivaluedMap;
import fish.payara.arquillian.ws.rs.ext.MessageBodyWriter;
import fish.payara.arquillian.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;

@Provider
@Produces(value={"application/json", "text/json", "*/*"})
public class JsonValueBodyWriter
implements MessageBodyWriter<JsonValue> {
    private static final String JSON = "json";
    private static final String PLUS_JSON = "+json";
    private JsonWriterFactory wf = Json.createWriterFactory(null);
    @Context
    private Configuration config;

    @PostConstruct
    private void init() {
        HashMap<String, Boolean> props = new HashMap<String, Boolean>();
        if (this.config != null && this.config.getProperties().containsKey("fish.payara.arquillian.javax.json.stream.JsonGenerator.prettyPrinting")) {
            props.put("fish.payara.arquillian.javax.json.stream.JsonGenerator.prettyPrinting", true);
        }
        this.wf = Json.createWriterFactory(props);
    }

    @Override
    public boolean isWriteable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return JsonValue.class.isAssignableFrom(aClass) && JsonValueBodyWriter.supportsMediaType(mediaType);
    }

    private static boolean supportsMediaType(MediaType mediaType) {
        return mediaType.getSubtype().equals(JSON) || mediaType.getSubtype().endsWith(PLUS_JSON);
    }

    @Override
    public long getSize(JsonValue jsonValue, Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public void writeTo(JsonValue jsonValue, Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> stringObjectMultivaluedMap, OutputStream outputStream) throws IOException, WebApplicationException {
        try (JsonWriter writer = this.wf.createWriter(outputStream);){
            writer.write(jsonValue);
        }
    }
}

