/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.shaded.glassfish.jersey.internal.guava;

import fish.payara.arquillian.shaded.glassfish.jersey.internal.guava.ExecutionList;
import fish.payara.arquillian.shaded.glassfish.jersey.internal.guava.ListenableFuture;
import fish.payara.arquillian.shaded.glassfish.jersey.internal.guava.Preconditions;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public abstract class AbstractFuture<V>
implements ListenableFuture<V> {
    private final Sync<V> sync = new Sync();
    private final ExecutionList executionList = new ExecutionList();

    AbstractFuture() {
    }

    private static CancellationException cancellationExceptionWithCause(Throwable cause) {
        CancellationException exception = new CancellationException("Task was cancelled.");
        exception.initCause(cause);
        return exception;
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        return this.sync.get(unit.toNanos(timeout));
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.sync.get();
    }

    @Override
    public boolean isDone() {
        return this.sync.isDone();
    }

    @Override
    public boolean isCancelled() {
        return this.sync.isCancelled();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (!this.sync.cancel(mayInterruptIfRunning)) {
            return false;
        }
        this.executionList.execute();
        if (mayInterruptIfRunning) {
            this.interruptTask();
        }
        return true;
    }

    private void interruptTask() {
    }

    final boolean wasInterrupted() {
        return this.sync.wasInterrupted();
    }

    @Override
    public void addListener(Runnable listener, Executor exec) {
        this.executionList.add(listener, exec);
    }

    boolean set(V value) {
        boolean result = this.sync.set(value);
        if (result) {
            this.executionList.execute();
        }
        return result;
    }

    boolean setException(Throwable throwable) {
        boolean result = this.sync.setException(Preconditions.checkNotNull(throwable));
        if (result) {
            this.executionList.execute();
        }
        return result;
    }

    static final class Sync<V>
    extends AbstractQueuedSynchronizer {
        static final int RUNNING = 0;
        static final int COMPLETING = 1;
        static final int COMPLETED = 2;
        static final int CANCELLED = 4;
        static final int INTERRUPTED = 8;
        private static final long serialVersionUID = 0L;
        private V value;
        private Throwable exception;

        Sync() {
        }

        @Override
        protected int tryAcquireShared(int ignored) {
            if (this.isDone()) {
                return 1;
            }
            return -1;
        }

        @Override
        protected boolean tryReleaseShared(int finalState) {
            this.setState(finalState);
            return true;
        }

        V get(long nanos) throws TimeoutException, CancellationException, ExecutionException, InterruptedException {
            if (!this.tryAcquireSharedNanos(-1, nanos)) {
                throw new TimeoutException("Timeout waiting for task.");
            }
            return this.getValue();
        }

        V get() throws CancellationException, ExecutionException, InterruptedException {
            this.acquireSharedInterruptibly(-1);
            return this.getValue();
        }

        private V getValue() throws CancellationException, ExecutionException {
            int state = this.getState();
            switch (state) {
                case 2: {
                    if (this.exception != null) {
                        throw new ExecutionException(this.exception);
                    }
                    return this.value;
                }
                case 4: 
                case 8: {
                    throw AbstractFuture.cancellationExceptionWithCause(this.exception);
                }
            }
            throw new IllegalStateException("Error, synchronizer in invalid state: " + state);
        }

        boolean isDone() {
            return (this.getState() & 0xE) != 0;
        }

        boolean isCancelled() {
            return (this.getState() & 0xC) != 0;
        }

        boolean wasInterrupted() {
            return this.getState() == 8;
        }

        boolean set(V v) {
            return this.complete(v, null, 2);
        }

        boolean setException(Throwable t) {
            return this.complete(null, t, 2);
        }

        boolean cancel(boolean interrupt) {
            return this.complete(null, null, interrupt ? 8 : 4);
        }

        private boolean complete(V v, Throwable t, int finalState) {
            boolean doCompletion = this.compareAndSetState(0, 1);
            if (doCompletion) {
                this.value = v;
                this.exception = (finalState & 0xC) != 0 ? new CancellationException("Future.cancel() was called.") : t;
                this.releaseShared(finalState);
            } else if (this.getState() == 1) {
                this.acquireShared(-1);
            }
            return doCompletion;
        }
    }
}

