/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.shaded.jvnet.mimepull;

import fish.payara.arquillian.shaded.jvnet.mimepull.Chunk;
import fish.payara.arquillian.shaded.jvnet.mimepull.Data;
import fish.payara.arquillian.shaded.jvnet.mimepull.DataFile;
import fish.payara.arquillian.shaded.jvnet.mimepull.DataHead;
import fish.payara.arquillian.shaded.jvnet.mimepull.FileData;
import fish.payara.arquillian.shaded.jvnet.mimepull.MIMEConfig;
import fish.payara.arquillian.shaded.jvnet.mimepull.MIMEParsingException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;

final class MemoryData
implements Data {
    private static final Logger LOGGER = Logger.getLogger(MemoryData.class.getName());
    private final byte[] data;
    private final int len;
    private final MIMEConfig config;
    private static final boolean DELETE_ON_EXIT = Boolean.getBoolean("fish.payara.arquillian.shaded.jvnet.mimepull.deletetemponexit");

    MemoryData(ByteBuffer buf, MIMEConfig config) {
        this.data = buf.array();
        this.len = buf.limit();
        this.config = config;
    }

    @Override
    public int size() {
        return this.len;
    }

    @Override
    public byte[] read() {
        return this.data;
    }

    @Override
    public long writeTo(DataFile file) {
        return file.writeTo(this.data, 0, this.len);
    }

    @Override
    public Data createNext(DataHead dataHead, ByteBuffer buf) {
        if (!this.config.isOnlyMemory() && dataHead.inMemory >= this.config.memoryThreshold) {
            try {
                String prefix = this.config.getTempFilePrefix();
                String suffix = this.config.getTempFileSuffix();
                File tempFile = MemoryData.createTempFile(prefix, suffix, this.config.getTempDir());
                if (DELETE_ON_EXIT) {
                    tempFile.deleteOnExit();
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Created temp file = {0}", tempFile);
                }
                dataHead.dataFile = new DataFile(tempFile);
            }
            catch (IOException ioe) {
                throw new MIMEParsingException(ioe);
            }
            if (dataHead.head != null) {
                Chunk c = dataHead.head;
                while (c != null) {
                    long pointer = c.data.writeTo(dataHead.dataFile);
                    c.data = new FileData(dataHead.dataFile, pointer, this.len);
                    c = c.next;
                }
            }
            return new FileData(dataHead.dataFile, buf);
        }
        return new MemoryData(buf, this.config);
    }

    private static File createTempFile(String prefix, String suffix, File dir) throws IOException {
        if (dir != null) {
            Path path = dir.toPath();
            return Files.createTempFile(path, prefix, suffix, new FileAttribute[0]).toFile();
        }
        return Files.createTempFile(prefix, suffix, new FileAttribute[0]).toFile();
    }
}

