/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.shaded.glassfish.jersey.internal;

import fish.payara.arquillian.shaded.glassfish.jersey.internal.PropertiesDelegate;
import fish.payara.arquillian.shaded.glassfish.jersey.internal.util.PropertiesHelper;
import fish.payara.arquillian.shaded.jakarta.ws.rs.core.Configuration;

public interface PropertiesResolver {
    public <T> T resolveProperty(String var1, Class<T> var2);

    public <T> T resolveProperty(String var1, T var2);

    public static PropertiesResolver create(final Configuration configuration, final PropertiesDelegate delegate) {
        return new PropertiesResolver(){

            @Override
            public <T> T resolveProperty(String name, Class<T> type) {
                return this.resolveProperty(name, null, type);
            }

            @Override
            public <T> T resolveProperty(String name, T defaultValue) {
                return (T)this.resolveProperty(name, defaultValue, defaultValue.getClass());
            }

            private <T> T resolveProperty(String name, Object defaultValue, Class<T> type) {
                Object result = configuration.getProperty(name);
                if (result != null) {
                    defaultValue = result;
                }
                if ((result = delegate.getProperty(name)) == null) {
                    result = defaultValue;
                }
                return result == null ? null : (T)PropertiesHelper.convertValue(result, type);
            }
        };
    }
}

