/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.shaded.glassfish.jersey.logging;

import fish.payara.arquillian.shaded.glassfish.jersey.logging.LoggingFeature;
import fish.payara.arquillian.shaded.glassfish.jersey.logging.LoggingInterceptor;
import fish.payara.arquillian.shaded.glassfish.jersey.message.MessageUtils;
import fish.payara.arquillian.shaded.jakarta.annotation.Priority;
import fish.payara.arquillian.shaded.jakarta.ws.rs.ConstrainedTo;
import fish.payara.arquillian.shaded.jakarta.ws.rs.RuntimeType;
import fish.payara.arquillian.shaded.jakarta.ws.rs.client.ClientRequestContext;
import fish.payara.arquillian.shaded.jakarta.ws.rs.client.ClientRequestFilter;
import fish.payara.arquillian.shaded.jakarta.ws.rs.client.ClientResponseContext;
import fish.payara.arquillian.shaded.jakarta.ws.rs.client.ClientResponseFilter;
import fish.payara.arquillian.shaded.jakarta.ws.rs.container.PreMatching;
import java.io.IOException;

@ConstrainedTo(value=RuntimeType.CLIENT)
@PreMatching
@Priority(value=0x7FFFFFFF)
final class ClientLoggingFilter
extends LoggingInterceptor
implements ClientRequestFilter,
ClientResponseFilter {
    public ClientLoggingFilter(LoggingFeature.LoggingFeatureBuilder builder) {
        super(builder);
    }

    @Override
    public void filter(ClientRequestContext context) throws IOException {
        if (!this.logger.isLoggable(this.level)) {
            return;
        }
        long id = this._id.incrementAndGet();
        context.setProperty(LOGGING_ID_PROPERTY, id);
        StringBuilder b = new StringBuilder();
        this.printRequestLine(b, "Sending client request", id, context.getMethod(), context.getUri());
        this.printPrefixedHeaders(b, id, "> ", context.getStringHeaders());
        if (context.hasEntity() && ClientLoggingFilter.printEntity(this.verbosity, context.getMediaType())) {
            LoggingInterceptor.LoggingStream stream = new LoggingInterceptor.LoggingStream(this, b, context.getEntityStream());
            context.setEntityStream(stream);
            context.setProperty(ENTITY_LOGGER_PROPERTY, stream);
        } else {
            this.log(b);
        }
    }

    @Override
    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        if (!this.logger.isLoggable(this.level)) {
            return;
        }
        Object requestId = requestContext.getProperty(LOGGING_ID_PROPERTY);
        long id = requestId != null ? ((Long)requestId).longValue() : this._id.incrementAndGet();
        StringBuilder b = new StringBuilder();
        this.printResponseLine(b, "Client response received", id, responseContext.getStatus());
        this.printPrefixedHeaders(b, id, "< ", responseContext.getHeaders());
        if (responseContext.hasEntity() && ClientLoggingFilter.printEntity(this.verbosity, responseContext.getMediaType())) {
            responseContext.setEntityStream(this.logInboundEntity(b, responseContext.getEntityStream(), MessageUtils.getCharset(responseContext.getMediaType())));
        }
        this.log(b);
    }
}

