/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.container.payara.process;

import fish.payara.arquillian.container.payara.process.ProcessOutputConsumer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConsoleReader
implements Runnable,
AutoCloseable {
    private static final Logger logger = Logger.getLogger(ConsoleReader.class.getName());
    private final ProcessOutputConsumer consumer;
    private final BufferedReader reader;
    private volatile boolean closing;

    public ConsoleReader(Process process, ProcessOutputConsumer consumer) {
        this.reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        this.consumer = consumer;
        this.closing = false;
    }

    @Override
    public void run() {
        try {
            while (!this.closing) {
                String line = this.reader.readLine();
                if (line == null) continue;
                this.consumer.consume(line);
            }
        }
        catch (IOException ex) {
        }
        finally {
            try {
                this.reader.close();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "An error occurred while closing the ConsoleReader.", ex);
            }
        }
    }

    public <T extends ProcessOutputConsumer> T getConsumer() {
        return (T)this.consumer;
    }

    @Override
    public void close() {
        this.closing = true;
    }
}

