/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.shaded.glassfish.jersey.inject.hk2;

import fish.payara.arquillian.shaded.glassfish.hk2.api.Factory;
import fish.payara.arquillian.shaded.glassfish.hk2.api.ServiceLocator;
import fish.payara.arquillian.shaded.glassfish.hk2.utilities.reflection.ParameterizedTypeImpl;
import fish.payara.arquillian.shaded.glassfish.jersey.internal.inject.DisposableSupplier;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Supplier;

public class SupplierFactoryBridge<T>
implements Factory<T> {
    private final ServiceLocator locator;
    private final ParameterizedType beanType;
    private final String beanName;
    private final boolean disposable;
    private Map<Object, DisposableSupplier<T>> disposableSuppliers = Collections.synchronizedMap(new IdentityHashMap());

    SupplierFactoryBridge(ServiceLocator locator, Type beanType, String beanName, boolean disposable) {
        this.locator = locator;
        this.beanType = new ParameterizedTypeImpl((Type)((Object)Supplier.class), beanType);
        this.beanName = beanName;
        this.disposable = disposable;
    }

    @Override
    public T provide() {
        if (this.beanType != null) {
            Supplier supplier = (Supplier)this.locator.getService((Type)this.beanType, this.beanName, new Annotation[0]);
            Object instance = supplier.get();
            if (this.disposable) {
                this.disposableSuppliers.put(instance, (DisposableSupplier)supplier);
            }
            return instance;
        }
        return null;
    }

    @Override
    public void dispose(T instance) {
        if (this.disposable) {
            DisposableSupplier<T> disposableSupplier = this.disposableSuppliers.remove(instance);
            disposableSupplier.dispose(instance);
        }
    }
}

