/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.microdeployer;

import fish.payara.arquillian.microdeployer.Deployer;
import fish.payara.micro.PayaraMicroRuntime;
import fish.payara.micro.data.ApplicationDescriptor;
import fish.payara.micro.data.InstanceDescriptor;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.ws.rs.ClientErrorException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

@RequestScoped
@Path(value="/application")
public class Deployer {
    private static final Logger LOGGER = Logger.getLogger(Deployer.class.getName());
    @Inject
    PayaraMicroRuntime runtime;
    String errorMessage = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="/{name}")
    @Consumes(value={"application/octet-stream"})
    @PUT
    public JsonObject deploy(@PathParam(value="name") String name, InputStream archive) throws Throwable {
        LOGGER.log(Level.INFO, "Starting deployment of {0}", name);
        this.errorMessage = null;
        CaptureExceptionHandler handler = new CaptureExceptionHandler();
        Logger serverLogger = LogManager.getLogManager().getLogger("javax.enterprise.system.core");
        handler.addToLogger(serverLogger);
        boolean deployOk = false;
        try {
            deployOk = this.runtime.deploy(name, archive);
        }
        finally {
            handler.removeFromLogger(serverLogger);
            this.errorMessage = handler.deploymentExceptionMessage;
        }
        if (!deployOk) {
            throw this.badRequest();
        }
        JsonObjectBuilder resultBuilder = Json.createObjectBuilder();
        InstanceDescriptor instance = this.runtime.getLocalDescriptor();
        ApplicationDescriptor descriptor = instance.getDeployedApplications().stream().filter(a -> a.getName().equals(name)).findFirst().orElseThrow(() -> this.badRequest());
        resultBuilder.add("name", name).add("httpPorts", Json.createArrayBuilder((Collection)instance.getHttpPorts()));
        descriptor.getModuleDescriptors().forEach(moduleDescriptor -> {
            JsonObjectBuilder moduleBuilder = Json.createObjectBuilder();
            moduleBuilder.add("type", moduleDescriptor.getType()).add("servletMappings", Json.createObjectBuilder((Map)moduleDescriptor.getServletMappings()));
            resultBuilder.add(moduleDescriptor.getName(), (JsonValue)moduleBuilder.build());
        });
        return resultBuilder.build();
    }

    private ClientErrorException badRequest() {
        if (this.errorMessage != null) {
            return this.badRequest(this.errorMessage);
        }
        return this.badRequest("Application failed to deploy. Check logs");
    }

    private ClientErrorException badRequest(String message) {
        JsonObjectBuilder resultBuilder = Json.createObjectBuilder();
        if (message != null) {
            resultBuilder.add("message", message);
        }
        return new ClientErrorException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)resultBuilder.build()).build());
    }

    @Path(value="/{name}")
    @DELETE
    public void undeploy(@PathParam(value="name") String name) {
        LOGGER.log(Level.INFO, "Starting undeployment of {0}", name);
        this.runtime.undeploy(name);
    }
}

