/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.container.payaramicro.remote;

import fish.payara.arquillian.container.payara.CommonPayaraConfiguration;
import org.jboss.arquillian.container.spi.ConfigurationException;

public class PayaraMicroRemoteContainerConfiguration
extends CommonPayaraConfiguration {
    private int httpPort = Integer.parseInt(PayaraMicroRemoteContainerConfiguration.getConfigurableVariable("payara.httpPort", "PAYARA_PORT", "8080"));
    private String deployerContextPath = PayaraMicroRemoteContainerConfiguration.getConfigurableVariable("payara.deployerPath", "PAYARA_DEPLOYER_PATH", "/payara-micro-deployer");

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public String getDeployerContextPath() {
        return this.deployerContextPath;
    }

    public void setDeployerContextPath(String deployerContextPath) {
        this.deployerContextPath = deployerContextPath;
    }

    public void validate() throws ConfigurationException {
        if (this.httpPort <= 0 || this.httpPort >= 65536) {
            throw new ConfigurationException("HTTP port is not set");
        }
        if (this.deployerContextPath == null || this.deployerContextPath.isEmpty() || !this.deployerContextPath.startsWith("/")) {
            throw new ConfigurationException("Deployer context path must be specified and start with a slash");
        }
    }

    private static String getConfigurableVariable(String systemPropertyName, String environmentVariableName, String defaultValue) {
        String systemProperty = System.getProperty(systemPropertyName);
        String environmentProperty = System.getenv(environmentVariableName);
        if (systemProperty == null || systemProperty.isEmpty()) {
            if (environmentProperty == null || environmentProperty.isEmpty()) {
                if (defaultValue == null || defaultValue.isEmpty()) {
                    return null;
                }
                return defaultValue;
            }
            return environmentProperty;
        }
        return systemProperty;
    }
}

