/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.container.payaramicro.remote;

import jakarta.enterprise.inject.spi.DefinitionException;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

class DeployerClient {
    private int port;
    private String contextPath;
    private static final String ENDPOINT = "/application/";

    DeployerClient(int port, String contextPath) {
        this.port = port;
        this.contextPath = contextPath.replaceFirst("/$", "");
    }

    Map<String, String> deploy(String name, InputStream archive) throws IOException {
        URL appUrl = this.applicationUrl(name);
        HttpURLConnection httpConnection = (HttpURLConnection)appUrl.openConnection();
        try {
            httpConnection.setRequestMethod("PUT");
            httpConnection.addRequestProperty("Content-Type", "application/octet-stream");
            httpConnection.setDoOutput(true);
            httpConnection.setDoInput(true);
            this.copy(archive, httpConnection.getOutputStream());
            int responseCode = httpConnection.getResponseCode();
            if (responseCode == 200) {
                Map<String, String> map = this.parseOutput(httpConnection.getInputStream());
                return map;
            }
            JsonObject json = Json.createReader(httpConnection.getErrorStream()).readObject();
            String message = json.getString("message", null);
            if (message != null) {
                if (message.startsWith("CDI definition failure")) {
                    throw new DefinitionException(this.composeMessageForException(responseCode, message));
                }
                if (message.startsWith("CDI deployment failure") || message.contains("org.jboss.weld.exceptions.DeploymentException")) {
                    throw new DeploymentException(this.composeMessageForException(responseCode, message));
                }
                throw new IllegalArgumentException(this.composeMessageForException(responseCode, message));
            }
            throw new IllegalArgumentException("Deployment failed. " + this + " returned " + responseCode);
        }
        finally {
            httpConnection.disconnect();
        }
    }

    private String composeMessageForException(int responseCode, String message) {
        return "Deployment failed. " + this + " returned " + responseCode + " with message: " + message;
    }

    private Map<String, String> parseOutput(InputStream inputStream) {
        JsonObject json = Json.createReader(inputStream).readObject();
        String moduleName = json.getString("name");
        JsonObject moduleDescriptor = json.getJsonObject(moduleName);
        JsonObject mappings = moduleDescriptor.getJsonObject("servletMappings");
        HashMap<String, String> parsedMappings = new HashMap<String, String>();
        mappings.forEach((path, servlet) -> parsedMappings.put((String)path, ((JsonString)servlet).getString()));
        return parsedMappings;
    }

    private void copy(InputStream archive, OutputStream sink) throws IOException {
        int n;
        byte[] buf = new byte[1024];
        while ((n = archive.read(buf)) > 0) {
            sink.write(buf, 0, n);
        }
    }

    private URL applicationUrl(String name) {
        try {
            return new URL("http", "localhost", this.port, this.contextPath + ENDPOINT + name);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(String name) throws IOException {
        URL appUrl = this.applicationUrl(name);
        HttpURLConnection httpConnection = (HttpURLConnection)appUrl.openConnection();
        try {
            httpConnection.setRequestMethod("DELETE");
            httpConnection.getResponseCode();
        }
        finally {
            httpConnection.disconnect();
        }
    }

    public String toString() {
        return "Payara Micro Deployer at http://localhost:" + this.port + this.contextPath;
    }
}

