/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.container.payaramicro.remote;

import fish.payara.arquillian.container.payaramicro.remote.DeployerClient;
import fish.payara.arquillian.container.payaramicro.remote.PayaraMicroRemoteContainerConfiguration;
import java.io.IOException;
import java.util.Map;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

public class PayaraMicroRemoteDeployableContainer
implements DeployableContainer<PayaraMicroRemoteContainerConfiguration> {
    private PayaraMicroRemoteContainerConfiguration configuration;
    private DeployerClient deployer;

    public Class<PayaraMicroRemoteContainerConfiguration> getConfigurationClass() {
        return PayaraMicroRemoteContainerConfiguration.class;
    }

    public void setup(PayaraMicroRemoteContainerConfiguration configuration) {
        this.configuration = configuration;
        this.deployer = new DeployerClient(configuration.getHttpPort(), configuration.getDeployerContextPath());
    }

    public void start() throws LifecycleException {
    }

    public void stop() throws LifecycleException {
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 6.0");
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        try {
            String baseName = PayaraMicroRemoteDeployableContainer.baseNameOf(archive);
            Map<String, String> mappings = this.deployer.deploy(baseName, ((ZipExporter)archive.as(ZipExporter.class)).exportAsInputStream());
            ProtocolMetaData metadata = new ProtocolMetaData();
            HTTPContext httpContext = new HTTPContext(baseName, "localhost", this.configuration.getHttpPort());
            mappings.forEach((path, servlet) -> httpContext.add(new Servlet(servlet, baseName)));
            metadata.addContext((Object)httpContext);
            return metadata;
        }
        catch (IOException e) {
            throw new DeploymentException("Failed to deploy archive to " + this.deployer, (Throwable)e);
        }
    }

    private static String baseNameOf(Archive<?> archive) {
        return archive.getName().replaceFirst("\\.\\w+$", "");
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        try {
            this.deployer.undeploy(PayaraMicroRemoteDeployableContainer.baseNameOf(archive));
        }
        catch (IOException e) {
            throw new DeploymentException("Failed to undeploy archive from " + this.deployer, (Throwable)e);
        }
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }
}

