/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.source;

import com.sun.enterprise.config.serverbeans.Domain;
import fish.payara.nucleus.microprofile.config.source.PayaraConfigSource;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

public class DomainConfigSource
extends PayaraConfigSource
implements ConfigSource {
    public Map<String, String> getProperties() {
        List properties = this.domainConfiguration.getProperty();
        HashMap<String, String> result = new HashMap<String, String>(properties.size());
        for (Property property : properties) {
            if (!property.getName().startsWith("payara.microprofile.")) continue;
            result.put(property.getName().substring("payara.microprofile.".length()), property.getValue());
        }
        return result;
    }

    public int getOrdinal() {
        return Integer.parseInt(this.configService.getMPConfig().getDomainOrdinality());
    }

    public String getValue(String propertyName) {
        return this.domainConfiguration.getPropertyValue("payara.microprofile." + propertyName);
    }

    public String getName() {
        return "Domain";
    }

    public void setValue(final String propertyName, final String propertyValue) throws TransactionFailure {
        Property p = this.domainConfiguration.getProperty("payara.microprofile." + propertyName);
        if (p == null) {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Domain>(){

                public Object run(Domain config) throws TransactionFailure, PropertyVetoException {
                    Property prop = (Property)config.createChild(Property.class);
                    prop.setName("payara.microprofile." + propertyName);
                    prop.setValue(propertyValue);
                    config.getProperty().add(prop);
                    return null;
                }
            }, (ConfigBeanProxy)this.domainConfiguration);
        } else {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Property>(){

                public Object run(Property config) throws TransactionFailure, PropertyVetoException {
                    config.setValue(propertyValue);
                    return null;
                }
            }, (ConfigBeanProxy)p);
        }
    }

    public void deleteValue(String propertyName) throws TransactionFailure {
        for (Property object : this.domainConfiguration.getProperty()) {
            if (!("payara.microprofile." + propertyName).equals(object.getName())) continue;
            ConfigSupport.deleteChild((ConfigBean)((ConfigBean)ConfigBean.unwrap((ConfigBeanProxy)this.domainConfiguration)), (ConfigBean)((ConfigBean)ConfigBean.unwrap((ConfigBeanProxy)object)));
        }
    }
}

