/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.source;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class EnvironmentConfigSource
implements ConfigSource {
    public Map<String, String> getProperties() {
        return EnvironmentConfigSource.getEnv();
    }

    public int getOrdinal() {
        return 300;
    }

    public String getValue(String propertyName) {
        String result = EnvironmentConfigSource.getEnv(propertyName);
        if (result == null) {
            propertyName = propertyName.replaceAll("[^A-Za-z0-9]", "_");
            result = EnvironmentConfigSource.getEnv(propertyName);
        }
        if (result == null) {
            propertyName = propertyName.toUpperCase();
        }
        return EnvironmentConfigSource.getEnv(propertyName);
    }

    public String getName() {
        return "Environment";
    }

    private static Map<String, String> getEnv() {
        PrivilegedAction<Map> action = System::getenv;
        return AccessController.doPrivileged(action);
    }

    private static String getEnv(String propertyName) {
        return EnvironmentConfigSource.getEnv().get(propertyName);
    }
}

