/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.source;

import fish.payara.nucleus.microprofile.config.source.JDBCConfigSourceHelper;
import fish.payara.nucleus.microprofile.config.source.PayaraConfigSource;
import fish.payara.nucleus.microprofile.config.spi.JDBCConfigSourceConfiguration;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.glassfish.internal.api.Globals;

public class JDBCConfigSource
extends PayaraConfigSource
implements ConfigSource {
    private static final Logger LOGGER = Logger.getLogger(JDBCConfigSource.class.getName());
    private final JDBCConfigSourceConfiguration config = Globals.getDefaultHabitat().getService(JDBCConfigSourceConfiguration.class, new Annotation[0]);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getProperties() {
        JDBCConfigSourceHelper helper = this.getHelper();
        if (helper == null) {
            return null;
        }
        try {
            Map<String, String> map = helper.getAllConfigValues();
            return map;
        }
        finally {
            try {
                helper.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Error closing JDBC connection", e);
            }
        }
    }

    public int getOrdinal() {
        return Integer.parseInt(this.configService.getMPConfig().getJdbcOrdinality());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue(String propertyName) {
        JDBCConfigSourceHelper helper = this.getHelper();
        if (helper == null) {
            return null;
        }
        try {
            String string = helper.getConfigValue(propertyName);
            return string;
        }
        finally {
            try {
                helper.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Error closing JDBC connection", e);
            }
        }
    }

    public String getName() {
        return "JDBC";
    }

    private JDBCConfigSourceHelper getHelper() {
        if (this.config != null) {
            return new JDBCConfigSourceHelper(this.config);
        }
        return null;
    }
}

