/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.source;

import fish.payara.nucleus.microprofile.config.source.PayaraConfigSource;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.glassfish.config.support.TranslatedConfigView;

public class PayaraExpressionConfigSource
extends PayaraConfigSource
implements ConfigSource {
    private final Properties properties;

    public PayaraExpressionConfigSource(Properties properties) {
        this.properties = properties;
    }

    public int getOrdinal() {
        return Integer.parseInt(this.configService.getMPConfig().getPayaraExpressionPropertiesOrdinality());
    }

    public Map<String, String> getProperties() {
        return this.properties.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> this.getValue(e.getValue().toString())));
    }

    public String getValue(String property) {
        String payaraExpression = this.properties.getProperty(property);
        String value = TranslatedConfigView.expandValue((String)payaraExpression);
        if (value == null || value.equals(payaraExpression)) {
            return null;
        }
        return value;
    }

    public String getName() {
        return "Payara Expression Properties";
    }

    PayaraExpressionConfigSource(boolean test, Properties properties) {
        super(test);
        this.properties = properties;
    }
}

