/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.spi;

import fish.payara.nucleus.microprofile.config.converters.ArrayConverter;
import fish.payara.nucleus.microprofile.config.spi.ConfigValueResolver;
import fish.payara.nucleus.microprofile.config.spi.PayaraConfig;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.spi.Converter;

final class ConfigValueResolverImpl
implements ConfigValueResolver {
    private final PayaraConfig config;
    private final String propertyName;
    private boolean throwsOnMissingProperty;
    private boolean throwOnFailedConversion;
    private boolean trim = true;
    private ConfigValueResolver.ElementPolicy policy = ConfigValueResolver.ElementPolicy.SKIP;
    private Long ttl;
    private String rawDefault;

    ConfigValueResolverImpl(PayaraConfig config, String propertyName) {
        this.config = config;
        this.propertyName = propertyName;
    }

    @Override
    public ConfigValueResolver withTTL(long ttl) {
        this.ttl = ttl < 0L ? null : Long.valueOf(ttl);
        return this;
    }

    @Override
    public ConfigValueResolver withDefault(String value) {
        this.rawDefault = "org.eclipse.microprofile.config.configproperty.unconfigureddvalue".equals(value) ? null : value;
        return this;
    }

    @Override
    public ConfigValueResolver withTrimming(boolean trim) {
        this.trim = trim;
        return this;
    }

    @Override
    public ConfigValueResolver withPolicy(ConfigValueResolver.ElementPolicy policy) {
        this.policy = policy;
        return this;
    }

    @Override
    public ConfigValueResolver throwOnMissingProperty(boolean throwOnMissingProperty) {
        this.throwsOnMissingProperty = throwOnMissingProperty;
        return this;
    }

    @Override
    public ConfigValueResolver throwOnFailedConversion(boolean throwOnFailedConversion) {
        this.throwOnFailedConversion = throwOnFailedConversion;
        return this;
    }

    @Override
    public <T> T as(Class<T> type, T defaultValue) {
        return this.asValue(this.propertyName, ConfigValueResolverImpl.getCacheKey(this.propertyName, type), this.ttl, defaultValue, () -> type.isArray() ? this.getArrayConverter(type.getComponentType(), false) : this.getConverter(type));
    }

    @Override
    public <T> Optional<T> as(Class<T> type) {
        return Optional.ofNullable(this.as(type, null));
    }

    @Override
    public <E> List<E> asList(Class<E> elementType) {
        return this.asList(elementType, Collections.emptyList());
    }

    @Override
    public <E> List<E> asList(Class<E> elementType, List<E> defaultValue) {
        return this.asValue(this.propertyName, ConfigValueResolverImpl.getCacheKey(this.propertyName, List.class, elementType), this.ttl, defaultValue, () -> ConfigValueResolverImpl.createListConverter(this.getArrayConverter(elementType, true)));
    }

    @Override
    public <E> Set<E> asSet(Class<E> elementType) {
        return this.asSet(elementType, Collections.emptySet());
    }

    @Override
    public <E> Set<E> asSet(Class<E> elementType, Set<E> defaultValue) {
        return this.asValue(this.propertyName, ConfigValueResolverImpl.getCacheKey(this.propertyName, Set.class, elementType), this.ttl, defaultValue, () -> ConfigValueResolverImpl.createSetConverter(this.getArrayConverter(elementType, true)));
    }

    @Override
    public <T> T asConvertedBy(Function<String, T> converter, T defaultValue) {
        String sourceValue = this.asValue(this.propertyName, ConfigValueResolverImpl.getCacheKey(this.propertyName, String.class), this.ttl, null, () -> (Converter & Serializable)value -> value);
        if (sourceValue == null) {
            if (this.throwsOnMissingProperty) {
                ConfigValueResolverImpl.throwWhenNotExists(this.propertyName, null);
            }
            return defaultValue;
        }
        try {
            return converter.apply(sourceValue);
        }
        catch (Exception ex) {
            if (this.rawDefault != null) {
                try {
                    return converter.apply(this.rawDefault);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.throwOnFailedConversion) {
                throw new IllegalArgumentException(ex);
            }
            return defaultValue;
        }
    }

    private <T> T asValue(String propertyName, String cacheKey, Long ttl, T defaultValue, Supplier<? extends Converter<T>> converter) {
        try {
            Object value = this.config.getValue(propertyName, cacheKey, ttl, this.getRawDefault(), converter);
            if (value != null) {
                return value;
            }
            if (this.throwsOnMissingProperty) {
                ConfigValueResolverImpl.throwWhenNotExists(propertyName, null);
            }
            return defaultValue;
        }
        catch (IllegalArgumentException ex) {
            if (this.throwOnFailedConversion) {
                throw ex;
            }
            return defaultValue;
        }
    }

    private String getRawDefault() {
        return this.throwsOnMissingProperty ? null : this.rawDefault;
    }

    private <T> Converter<T> getConverter(Class<T> type) {
        TrimConverter converter = this.config.getConverter(type);
        return this.trim ? new TrimConverter(converter) : converter;
    }

    private <E> Converter<E[]> getArrayConverter(Class<E> elementType, boolean box) {
        Converter<E> elementConverter = this.getConverter(elementType);
        if (box) {
            elementType = PayaraConfig.boxedTypeOf(elementType);
        }
        ArrayConverter<E> arrayConverter = new ArrayConverter<E>(elementType, elementConverter, this.policy);
        return arrayConverter;
    }

    static void throwWhenNotExists(String propertyName, Object value) {
        if (value == null) {
            throw new NoSuchElementException("Unable to find property with name " + propertyName);
        }
    }

    static String getCacheKey(String propertyName, Class<?> propertyType) {
        String key = propertyType.getName() + ":" + propertyName;
        return key;
    }

    static <E> String getCacheKey(String propertyName, Class<?> collectionType, Class<E> elementType) {
        return collectionType.getName() + ":" + ConfigValueResolverImpl.getCacheKey(propertyName, elementType);
    }

    static <E> Converter<List<E>> createListConverter(Converter<E[]> arrayConverter) {
        return (Converter & Serializable)sourceValue -> Arrays.asList((Object[])arrayConverter.convert(sourceValue));
    }

    static <E> Converter<Set<E>> createSetConverter(Converter<E[]> arrayConverter) {
        return (Converter & Serializable)sourceValue -> new HashSet<Object>(Arrays.asList((Object[])arrayConverter.convert(sourceValue)));
    }

    private static final class TrimConverter<T>
    implements Converter<T> {
        private final Converter<T> wrapped;

        TrimConverter(Converter<T> wrapped) {
            this.wrapped = wrapped;
        }

        public T convert(String value) {
            return (T)this.wrapped.convert(value.trim());
        }
    }
}

