/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.microprofile.config.spi;

import fish.payara.nucleus.microprofile.config.converters.ArrayConverter;
import fish.payara.nucleus.microprofile.config.converters.AutomaticConverter;
import fish.payara.nucleus.microprofile.config.spi.ConfigSourceComparator;
import fish.payara.nucleus.microprofile.config.spi.ConfigValueResolver;
import fish.payara.nucleus.microprofile.config.spi.ConfigValueResolverImpl;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

public class PayaraConfig
implements Config {
    private static final int DEFAULT_TTL = 60;
    private final List<ConfigSource> sources;
    private final Map<Class<?>, Converter<?>> converters;
    private final long ttl;
    private final Map<String, CacheEntry> cachedValuesByProperty = new ConcurrentHashMap<String, CacheEntry>();

    public PayaraConfig(List<ConfigSource> configSources, Map<Class<?>, Converter<?>> converters) {
        this(configSources, converters, TimeUnit.SECONDS.toMillis(60L));
    }

    public PayaraConfig(List<ConfigSource> sources, Map<Class<?>, Converter<?>> converters, long ttl) {
        this.sources = sources;
        this.converters = new ConcurrentHashMap(converters);
        this.ttl = ttl;
        Collections.sort(sources, new ConfigSourceComparator());
    }

    long getTTL() {
        return this.ttl;
    }

    public <T> T getValue(String propertyName, Class<T> propertyType) {
        if (propertyType == ConfigValueResolver.class) {
            return (T)new ConfigValueResolverImpl(this, propertyName);
        }
        T value = this.getValueInternal(propertyName, propertyType);
        ConfigValueResolverImpl.throwWhenNotExists(propertyName, value);
        return value;
    }

    public <T> Optional<T> getOptionalValue(String propertyName, Class<T> propertyType) {
        return Optional.ofNullable(this.getValueInternal(propertyName, propertyType));
    }

    private <T> T getValueInternal(String propertyName, Class<T> propertyType) {
        return this.getValue(propertyName, ConfigValueResolverImpl.getCacheKey(propertyName, propertyType), this.ttl, null, () -> this.getConverter(propertyType));
    }

    public Iterable<String> getPropertyNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (ConfigSource configSource : this.sources) {
            result.addAll(configSource.getProperties().keySet());
        }
        return result;
    }

    public Iterable<ConfigSource> getConfigSources() {
        return this.sources;
    }

    public Set<Class<?>> getConverterTypes() {
        return this.converters.keySet();
    }

    public <T> T getValue(String propertyName, String cacheKey, Long ttl, String defaultValue, Supplier<? extends Converter<T>> converter) {
        long entryTTL;
        long l = entryTTL = ttl == null ? this.ttl : ttl;
        if (entryTTL <= 0L) {
            return this.getValueConverted(propertyName, defaultValue, converter.get());
        }
        String entryKey = cacheKey + (defaultValue != null ? ":" + defaultValue : "") + ":" + entryTTL / 1000L + "s";
        long now = System.currentTimeMillis();
        return (T)this.cachedValuesByProperty.compute((String)entryKey, (BiFunction<String, CacheEntry, CacheEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$getValue$1(long java.lang.String java.lang.String java.util.function.Supplier long java.lang.String fish.payara.nucleus.microprofile.config.spi.PayaraConfig$CacheEntry ), (Ljava/lang/String;Lfish/payara/nucleus/microprofile/config/spi/PayaraConfig$CacheEntry;)Lfish/payara/nucleus/microprofile/config/spi/PayaraConfig$CacheEntry;)((PayaraConfig)this, (long)now, (String)propertyName, (String)defaultValue, converter, (long)entryTTL)).value;
    }

    private <T> T getValueConverted(String propertyName, String defaultValue, Converter<T> converter) {
        String sourceValue = this.getSourceValue(propertyName);
        if (sourceValue == null) {
            return (T)(defaultValue == null ? null : converter.convert(defaultValue));
        }
        try {
            return (T)converter.convert(sourceValue);
        }
        catch (IllegalArgumentException ex) {
            if (defaultValue == null) {
                throw ex;
            }
            return (T)converter.convert(defaultValue);
        }
    }

    private String getSourceValue(String propertyName) {
        for (ConfigSource source : this.sources) {
            String sourceValue = source.getValue(propertyName);
            if (sourceValue == null) continue;
            return sourceValue;
        }
        return null;
    }

    public <T> Converter<T> getConverter(Class<T> propertyType) {
        if (propertyType.isArray()) {
            return this.createArrayConverter(propertyType.getComponentType());
        }
        Class<?> type = PayaraConfig.boxedTypeOf(propertyType);
        Converter<?> converter = this.converters.get(type);
        if (converter != null) {
            return converter;
        }
        Optional<Converter<?>> automaticConverter = AutomaticConverter.forType(type);
        if (automaticConverter.isPresent()) {
            this.converters.put(type, automaticConverter.get());
            return automaticConverter.get();
        }
        throw new IllegalArgumentException("Unable to convert value to type " + type.getTypeName());
    }

    private <E> Converter<Object> createArrayConverter(Class<E> elementType) {
        return new ArrayConverter<E>(elementType, this.getConverter(elementType));
    }

    static Class<?> boxedTypeOf(Class<?> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        return Void.class;
    }

    private /* synthetic */ CacheEntry lambda$getValue$1(long now, String propertyName, String defaultValue, Supplier converter, long entryTTL, String key, CacheEntry entry) {
        if (entry != null && now < entry.expires) {
            return entry;
        }
        return new CacheEntry(this.getValueConverted(propertyName, defaultValue, (Converter)converter.get()), now + entryTTL);
    }

    private static final class CacheEntry {
        final Object value;
        final long expires;

        CacheEntry(Object value, long expires) {
            this.value = value;
            this.expires = expires;
        }
    }
}

