/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.asadmin.recorder;

import fish.payara.asadmin.recorder.AsadminRecorderConfiguration;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.config.support.TranslatedConfigView;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;

@Service(name="asadmin-recorder")
@RunLevel(value=10)
public class AsadminRecorderService
implements EventListener {
    private static final List<String> FILTERED_PARAMETERS = Arrays.asList("userpassword");
    private List<String> filteredCommands;
    private String filteredCommandsString;
    private List<String> prependedOptions;
    private String prependedOptionsString;
    @Inject
    @Named(value="default-instance-name")
    @Optional
    AsadminRecorderConfiguration asadminRecorderConfiguration;
    @Inject
    Events events;
    @Inject
    ServiceLocator habitat;

    @PostConstruct
    void postConstruct() {
        this.events.register((EventListener)this);
        this.asadminRecorderConfiguration = (AsadminRecorderConfiguration)this.habitat.getService(AsadminRecorderConfiguration.class, new Annotation[0]);
        this.splitFilteredCommands();
        this.setPrependedOptions();
    }

    public void event(EventListener.Event event) {
    }

    private String constructAsadminCommand(String commandName, ParameterMap parameters) {
        String asadminCommand = commandName;
        String mandatoryOption = "";
        if (Boolean.parseBoolean(this.asadminRecorderConfiguration.prependEnabled()) && this.prependedOptions != null) {
            for (String s : this.prependedOptions) {
                asadminCommand = asadminCommand + " " + s;
            }
        }
        for (Map.Entry parameter : parameters.entrySet()) {
            if (FILTERED_PARAMETERS.contains(parameter.getKey())) continue;
            if (((String)parameter.getKey()).equals("DEFAULT")) {
                for (int i = 0; i < ((List)parameter.getValue()).size(); ++i) {
                    mandatoryOption = mandatoryOption + (String)((List)parameter.getValue()).get(i);
                    if (i == ((List)parameter.getValue()).size() - 1) continue;
                    mandatoryOption = mandatoryOption + " ";
                }
                continue;
            }
            asadminCommand = asadminCommand + " --" + (String)parameter.getKey() + "=" + (String)((List)parameter.getValue()).get(0);
        }
        asadminCommand = asadminCommand + " " + mandatoryOption;
        asadminCommand = asadminCommand + "\n";
        return asadminCommand;
    }

    public boolean isEnabled() {
        boolean enabled = false;
        if (this.asadminRecorderConfiguration == null) {
            Logger.getLogger(AsadminRecorderService.class.getName()).log(Level.FINE, "No Asadmin Recorder Service configuration found, it is likely missing from the domain.xml. Setting enabled to default of false");
        } else {
            enabled = Boolean.parseBoolean(this.asadminRecorderConfiguration.isEnabled());
        }
        return enabled;
    }

    public void recordAsadminCommand(String commandName, ParameterMap parameters) {
        String asadminCommand = "";
        if (this.asadminRecorderConfiguration.getPrependedOptions() != null && !this.prependedOptionsString.equals(this.asadminRecorderConfiguration.getPrependedOptions())) {
            this.setPrependedOptions();
        }
        if (!this.filteredCommandsString.equals(this.asadminRecorderConfiguration.getFilteredCommands())) {
            this.splitFilteredCommands();
        }
        if (Boolean.parseBoolean(this.asadminRecorderConfiguration.filterCommands())) {
            if (!this.filteredCommands.contains(commandName)) {
                boolean regexMatched = false;
                for (String filteredCommand : this.filteredCommands) {
                    if (!commandName.matches(filteredCommand)) continue;
                    regexMatched = true;
                }
                if (!regexMatched) {
                    asadminCommand = this.constructAsadminCommand(commandName, parameters);
                }
            }
        } else {
            asadminCommand = this.constructAsadminCommand(commandName, parameters);
        }
        boolean substitutionEnabled = (Boolean)TranslatedConfigView.doSubstitution.get();
        TranslatedConfigView.doSubstitution.set(true);
        String asadminRecorderFileLocation = this.asadminRecorderConfiguration.getOutputLocation();
        TranslatedConfigView.doSubstitution.set(substitutionEnabled);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(new File(asadminRecorderFileLocation), true));){
            writer.write(asadminCommand);
        }
        catch (IOException ex) {
            Logger.getLogger(AsadminRecorderService.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void splitFilteredCommands() {
        this.filteredCommandsString = this.asadminRecorderConfiguration.getFilteredCommands();
        this.filteredCommands = new ArrayList<String>(Arrays.asList(this.filteredCommandsString.split(",")));
    }

    private void setPrependedOptions() {
        this.prependedOptionsString = this.asadminRecorderConfiguration.getPrependedOptions();
        if (this.prependedOptionsString != null) {
            this.prependedOptions = new ArrayList<String>(Arrays.asList(this.prependedOptionsString.split(",")));
            for (String option : this.prependedOptions) {
                String optionWithoutParameters = option.split("( |=)")[0];
                if (optionWithoutParameters.length() == 1) {
                    this.prependedOptions.set(this.prependedOptions.indexOf(option), "-" + option);
                    continue;
                }
                this.prependedOptions.set(this.prependedOptions.indexOf(option), "--" + option);
            }
        }
    }
}

