/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.loader.CurrentBeforeParentClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.server.CommonClassLoaderServiceImpl;
import com.sun.enterprise.v3.server.DomainXmlPersistence;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.deployment.admin.DeploymentCommandUtils;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.config.UnprocessedConfigListener;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.UnprocessedChangeEvent;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service(name="add-library")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="add-library", description="Install library")})
@AccessRequired(resource={"domain/libraries/$type"}, action={"create"})
public class AddLibraryCommand
implements AdminCommand {
    @Param(primary=true, multiple=true)
    File[] files = null;
    @Param(optional=true, acceptableValues="common, ext, app")
    String type = "common";
    @Inject
    ServerEnvironment env;
    @Inject
    DomainXmlPersistence dxp;
    @Inject
    UnprocessedConfigListener ucl;
    @Inject
    CommonClassLoaderServiceImpl commonClsLdr;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(AddLibraryCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = Logger.getLogger("org.glassfish.deployment.admin");
        File libDir = this.env.getLibPath();
        if (this.type.equals("ext")) {
            libDir = new File(libDir, "ext");
        } else if (this.type.equals("app")) {
            libDir = new File(libDir, "applibs");
        }
        try {
            ArrayList<UnprocessedChangeEvent> unprocessed = new ArrayList<UnprocessedChangeEvent>();
            StringBuilder msg = new StringBuilder();
            ClassLoader commonLoader = this.commonClsLdr.getCommonClassLoader();
            CurrentBeforeParentClassLoader loader = null;
            if (commonLoader instanceof CurrentBeforeParentClassLoader) {
                loader = (CurrentBeforeParentClassLoader)commonLoader;
            }
            for (File libraryFile : this.files) {
                if (libraryFile.exists()) {
                    logger.log(Level.FINER, "ready to add new library");
                    File result = DeploymentCommandUtils.renameUploadedFileOrCopyInPlaceFile(libDir, libraryFile, logger, this.env);
                    if (loader != null && !this.type.equals("applibs")) {
                        loader.addURL(result.toURI().toURL());
                        logger.log(Level.FINE, "added library to classloader", loader);
                        continue;
                    }
                    PropertyChangeEvent pe = new PropertyChangeEvent(libDir, "add-library", null, libraryFile);
                    UnprocessedChangeEvent uce = new UnprocessedChangeEvent(pe, "add-library");
                    unprocessed.add(uce);
                    logger.log(Level.FINER, "library not added to classloader");
                    continue;
                }
                msg.append(localStrings.getLocalString("lfnf", "Library file not found", new Object[]{libraryFile.getAbsolutePath()}));
            }
            if (msg.length() > 0) {
                logger.log(Level.WARNING, msg.toString());
                report.setActionExitCode(ActionReport.ExitCode.WARNING);
                report.setMessage(msg.toString());
            }
            if (!unprocessed.isEmpty()) {
                UnprocessedChangeEvents uces = new UnprocessedChangeEvents(unprocessed);
                ArrayList<UnprocessedChangeEvents> ucesList = new ArrayList<UnprocessedChangeEvents>();
                ucesList.add(uces);
                this.ucl.unprocessedTransactedEvents(ucesList);
            }
            this.dxp.touch();
        }
        catch (Exception e) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(e.getMessage());
        }
    }
}

