/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import fish.payara.enterprise.config.serverbeans.DeploymentGroup;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="update-application-ref")
@I18n(value="update.application.ref.command")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.DEPLOYMENT_GROUP})
@RestEndpoints(value={@RestEndpoint(configBean=Cluster.class, opType=RestEndpoint.OpType.POST, path="update-application-ref", description="Update an Application Reference on a cluster target"), @RestEndpoint(configBean=Server.class, opType=RestEndpoint.OpType.POST, path="update-application-ref", description="Update an Application Reference on a server target"), @RestEndpoint(configBean=DeploymentGroup.class, opType=RestEndpoint.OpType.POST, path="update-application-ref", description="Update an Application Reference on a server target")})
public class UpdateApplicationRefCommand
implements AdminCommand {
    private static final LocalStringManagerImpl LOCAL_STRINGS = new LocalStringManagerImpl(UpdateApplicationRefCommand.class);
    @Param(primary=true)
    private String name;
    @Param(optional=true, defaultValue="server")
    private String target;
    @Param(optional=true, alias="virtual-servers")
    private String virtualservers = null;
    @Param(optional=true)
    private Boolean enabled = null;
    @Param(optional=true)
    private Boolean lbenabled = null;
    @Inject
    private Domain domain;

    public void execute(AdminCommandContext context) {
        DeploymentGroup dg;
        final ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        ArrayList<ApplicationRef> applicationRefsToChange = new ArrayList<ApplicationRef>();
        ApplicationRef primaryApplicationRef = this.domain.getApplicationRefInTarget(this.name, this.target);
        if (primaryApplicationRef == null) {
            report.failure(logger, LOCAL_STRINGS.getLocalString("appref.not.exists", "Target {1} does not have a reference to application {0}.", new Object[]{this.name, this.target}));
            return;
        }
        applicationRefsToChange.add(primaryApplicationRef);
        Cluster cluster = this.domain.getClusterNamed(this.target);
        if (cluster != null) {
            for (Server server : cluster.getInstances()) {
                ApplicationRef instanceAppRef = server.getApplicationRef(this.name);
                if (instanceAppRef == null) continue;
                applicationRefsToChange.add(instanceAppRef);
            }
        }
        if ((dg = this.domain.getDeploymentGroupNamed(this.target)) != null) {
            for (Server server : dg.getInstances()) {
                ApplicationRef instanceAppRef = server.getApplicationRef(this.name);
                if (instanceAppRef == null) continue;
                applicationRefsToChange.add(instanceAppRef);
            }
        }
        try {
            ConfigSupport.apply((ConfigCode)new ConfigCode(){

                public Object run(ConfigBeanProxy ... params) throws PropertyVetoException, TransactionFailure {
                    for (ConfigBeanProxy proxy : params) {
                        if (!(proxy instanceof ApplicationRef)) continue;
                        ApplicationRef applicationRefProxy = (ApplicationRef)proxy;
                        if (UpdateApplicationRefCommand.this.enabled != null) {
                            applicationRefProxy.setEnabled(UpdateApplicationRefCommand.this.enabled.toString());
                        }
                        if (UpdateApplicationRefCommand.this.virtualservers != null) {
                            applicationRefProxy.setVirtualServers(UpdateApplicationRefCommand.this.virtualservers);
                        }
                        if (UpdateApplicationRefCommand.this.lbenabled == null) continue;
                        applicationRefProxy.setLbEnabled(UpdateApplicationRefCommand.this.lbenabled.toString());
                    }
                    report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                    return true;
                }
            }, (ConfigBeanProxy[])((ConfigBeanProxy[])applicationRefsToChange.toArray(new ApplicationRef[0])));
        }
        catch (TransactionFailure ex) {
            report.failure(logger, ex.getLocalizedMessage());
        }
    }
}

