/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.interceptors;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class InterceptorUtil {
    private static final Map<Class<?>, Set<Class<?>>> compatiblePrimitiveWrapper = InterceptorUtil.createMapping();

    static Map<Class<?>, Set<Class<?>>> createMapping() {
        HashMap mapping = new HashMap();
        mapping.put(Byte.TYPE, InterceptorUtil.asSet(Byte.class));
        mapping.put(Boolean.TYPE, InterceptorUtil.asSet(Boolean.class));
        mapping.put(Character.TYPE, InterceptorUtil.asSet(Character.class));
        mapping.put(Double.TYPE, InterceptorUtil.asSet(Byte.class, Short.class, Integer.class, Float.class, Double.class));
        mapping.put(Float.TYPE, InterceptorUtil.asSet(Byte.class, Short.class, Integer.class, Float.class));
        mapping.put(Integer.TYPE, InterceptorUtil.asSet(Byte.class, Short.class, Integer.class));
        mapping.put(Long.TYPE, InterceptorUtil.asSet(Byte.class, Short.class, Integer.class, Long.class));
        mapping.put(Short.TYPE, InterceptorUtil.asSet(Byte.class, Short.class));
        return Collections.unmodifiableMap(mapping);
    }

    private static Set<Class<?>> asSet(Class<?> ... classes) {
        HashSet set = new HashSet(classes.length);
        for (Class<?> c : classes) {
            set.add(c);
        }
        return Collections.unmodifiableSet(set);
    }

    public static boolean hasCompatiblePrimitiveWrapper(Class<?> type, Class<?> typeTo) {
        Set<Class<?>> compatibles = compatiblePrimitiveWrapper.get(type);
        return compatibles != null && compatibles.contains(typeTo);
    }

    public static void checkSetParameters(Object[] params, Method method) {
        if (method == null) {
            throw new IllegalStateException("Internal Error: Got null method");
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        if (params == null) {
            if (paramTypes.length != 0) {
                throw new IllegalArgumentException("Wrong number of parameters for  method: " + method);
            }
        } else {
            if (paramTypes.length != params.length) {
                throw new IllegalArgumentException("Wrong number of parameters for  method: " + method);
            }
            int index = 0;
            for (Class<?> type : paramTypes) {
                if (params[index] == null) {
                    if (type.isPrimitive()) {
                        throw new IllegalArgumentException("Parameter type mismatch for method " + method.getName() + ".  Attempt to set a null value for Arg[" + index + "]. Expected a value of type: " + type.getName());
                    }
                } else if (type.isPrimitive()) {
                    Set<Class<?>> compatibles = compatiblePrimitiveWrapper.get(type);
                    if (!compatibles.contains(params[index].getClass())) {
                        throw new IllegalArgumentException("Parameter type mismatch for method " + method.getName() + ".  Arg[" + index + "] type: " + params[index].getClass().getName() + " is not compatible with the expected type: " + type.getName());
                    }
                } else if (!type.isAssignableFrom(params[index].getClass())) {
                    throw new IllegalArgumentException("Parameter type mismatch for method " + method.getName() + ".  Arg[" + index + "] type: " + params[index].getClass().getName() + " does not match the expected type: " + type.getName());
                }
                ++index;
            }
        }
    }
}

