/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.monitoring.stats;

import com.sun.ejb.containers.StatefulSessionContainer;
import com.sun.ejb.monitoring.stats.EjbMonitoringStatsProvider;
import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.RangeStatistic;
import org.glassfish.external.statistics.impl.BoundedRangeStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;

@AMXMetadata(type="stateful-session-bean-mon", group="monitoring", isSingleton=false)
@ManagedObject
public class StatefulSessionBeanStatsProvider
extends EjbMonitoringStatsProvider {
    private BoundedRangeStatisticImpl methodReadyStat = null;
    private BoundedRangeStatisticImpl passiveCount = null;
    private final AtomicLong methodReadyCount = new AtomicLong();
    private final AtomicLong passivations = new AtomicLong();

    public StatefulSessionBeanStatsProvider(StatefulSessionContainer delegate, long beanId, String appName, String moduleName, String beanName) {
        super(beanId, appName, moduleName, beanName);
        long now = System.currentTimeMillis();
        this.methodReadyStat = new BoundedRangeStatisticImpl(0L, 0L, 0L, (long)delegate.getMaxCacheSize(), 0L, "MethodReadyCount", "count", "Number of stateful session beans in MethodReady state", now, now);
        this.passiveCount = new BoundedRangeStatisticImpl(0L, 0L, 0L, Long.MAX_VALUE, 0L, "PassiveCount", "count", "Number of stateful session beans in Passive state", now, now);
    }

    @ManagedAttribute(id="methodreadycount")
    @Description(value="Number of stateful session beans in MethodReady state")
    public RangeStatistic getMethodReadyCount() {
        this.methodReadyStat.setCurrent(this.methodReadyCount.get());
        return this.methodReadyStat;
    }

    @ManagedAttribute(id="passivecount")
    @Description(value="Number of stateful session beans in Passive state")
    public RangeStatistic getPassiveCount() {
        this.passiveCount.setCurrent(this.passivations.get());
        return this.passiveCount;
    }

    @ProbeListener(value="glassfish:ejb:bean:methodReadyAddEvent")
    public void methodReadyAddEvent(@ProbeParam(value="beanId") long beanId, @ProbeParam(value="appName") String appName, @ProbeParam(value="modName") String modName, @ProbeParam(value="ejbName") String ejbName) {
        if (this.beanId == beanId) {
            this.log("methodReadyAddEvent", "StatefulSessionBeanStatsProvider");
            this.methodReadyCount.incrementAndGet();
        }
    }

    @ProbeListener(value="glassfish:ejb:bean:methodReadyRemoveEvent")
    public void methodReadyRemoveEvent(@ProbeParam(value="beanId") long beanId, @ProbeParam(value="appName") String appName, @ProbeParam(value="modName") String modName, @ProbeParam(value="ejbName") String ejbName) {
        if (this.beanId == beanId) {
            this.log("methodReadyRemoveEvent", "StatefulSessionBeanStatsProvider");
            this.methodReadyCount.decrementAndGet();
        }
    }

    @ProbeListener(value="glassfish:ejb:cache:beanPassivatedEvent")
    public void ejbBeanPassivatedEvent(@ProbeParam(value="beanId") long beanId, @ProbeParam(value="appName") String appName, @ProbeParam(value="modName") String modName, @ProbeParam(value="ejbName") String ejbName, @ProbeParam(value="success") boolean success) {
        if (this.beanId == beanId && success) {
            this.log("beanPassivatedEvent", "StatefulSessionBeanStatsProvider");
            this.passivations.incrementAndGet();
        }
    }

    @ProbeListener(value="glassfish:ejb:cache:expiredSessionsRemovedEvent")
    public void ejbExpiredSessionsRemovedEvent(@ProbeParam(value="beanId") long beanId, @ProbeParam(value="appName") String appName, @ProbeParam(value="modName") String modName, @ProbeParam(value="ejbName") String ejbName, @ProbeParam(value="num") long num) {
        if (this.beanId == beanId) {
            this.log("expiredSessionsRemovedEvent", "StatefulSessionBeanStatsProvider");
            this.passivations.addAndGet(-num);
        }
    }

    public void setPassiveCount(long passiveCount) {
        this.passivations.set(passiveCount);
    }
}

