/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.admin.cli;

import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.EjbContainerUtil;
import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import fish.payara.enterprise.config.serverbeans.DeploymentGroup;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.common.util.admin.ParameterMapExtractor;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="migrate-timers")
@PerLookup
@I18n(value="migrate.timers")
@ExecuteOn(value={RuntimeType.INSTANCE}, ifNeverStarted=FailurePolicy.Error)
@TargetType(value={CommandTarget.DAS, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.STANDALONE_INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=Cluster.class, opType=RestEndpoint.OpType.POST, path="migrate-timers", description="Migrate Timers"), @RestEndpoint(configBean=DeploymentGroup.class, opType=RestEndpoint.OpType.POST, path="migrate-timers", description="Migrate Timers")})
public class MigrateTimers
implements AdminCommand {
    static StringManager localStrings = StringManager.getManager(MigrateTimers.class);
    private static final Logger logger = LogDomains.getLogger(MigrateTimers.class, (String)"javax.enterprise.system.container.ejb");
    @Param(name="target", optional=true, alias="destination", defaultValue="server")
    public String target;
    private boolean needRedirect;
    @Param(name="fromServer", primary=true, optional=false)
    public String fromServer;
    @Inject
    private EjbContainerUtil ejbContainerUtil;
    @Inject
    private Domain domain;
    @Inject
    Target targetUtil;
    @Inject
    private ServiceLocator habitat;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        String error = this.validate();
        if (error != null) {
            report.setMessage(error);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            if (this.needRedirect) {
                this.needRedirect = false;
                ParameterMapExtractor mapExtractor = new ParameterMapExtractor(new Object[]{this});
                ParameterMap params = mapExtractor.extract();
                logger.info(localStrings.getString("migrate.timers.redirect", (Object)this.target, (Object)params.toCommaSeparatedString()));
                ClusterOperationUtil.replicateCommand((String)"migrate-timers", (FailurePolicy)FailurePolicy.Error, (FailurePolicy)FailurePolicy.Error, (FailurePolicy)FailurePolicy.Error, Arrays.asList(this.target), (AdminCommandContext)context, (ParameterMap)params, (ServiceLocator)this.habitat);
                return;
            }
            int totalTimersMigrated = this.migrateTimers(this.fromServer);
            report.setMessage(localStrings.getString("migrate.timers.count", (Object)totalTimersMigrated, (Object)this.fromServer, (Object)this.target));
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }

    private String validate() {
        if (this.targetUtil.isCluster(this.target)) {
            return this.validateCluster();
        }
        return this.validateDG();
    }

    private boolean isServerRunning(String serverName) {
        Server server = this.domain.getServerNamed(serverName);
        return server == null ? false : server.isRunning();
    }

    private int migrateTimers(String serverId) {
        EJBTimerService ejbTimerService;
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "[MigrateTimers] migrating timers from {0}", serverId);
        }
        int result = 0;
        if (EJBTimerService.isPersistentTimerServiceLoaded() && (ejbTimerService = EJBTimerService.getPersistentTimerService()) != null) {
            result = ejbTimerService.migrateTimers(serverId);
        }
        return result;
    }

    private String validateCluster() {
        Cluster fromServerCluster = this.targetUtil.getClusterForInstance(this.fromServer);
        if (fromServerCluster == null) {
            return localStrings.getString("migrate.timers.fromServerNotClusteredInstance", (Object)this.fromServer);
        }
        if (this.isServerRunning(this.fromServer)) {
            return localStrings.getString("migrate.timers.migrateFromServerStillRunning", (Object)this.fromServer);
        }
        if (this.target.equals("server")) {
            List instances = fromServerCluster.getInstances();
            for (Server instance : instances) {
                if (!instance.isRunning()) continue;
                this.target = instance.getName();
                this.needRedirect = true;
            }
            if (this.target.equals("server")) {
                return localStrings.getString("migrate.timers.noRunningInstanceToChoose", (Object)this.target);
            }
        } else {
            Cluster destinationServerCluster = this.targetUtil.getClusterForInstance(this.target);
            if (!fromServerCluster.getName().equals(destinationServerCluster.getName())) {
                return localStrings.getString("migrate.timers.fromServerAndTargetNotInSameCluster", (Object)this.fromServer, (Object)this.target);
            }
            if (!this.isServerRunning(this.target)) {
                return localStrings.getString("migrate.timers.destinationServerIsNotAlive", (Object)this.target);
            }
        }
        return null;
    }

    private String validateDG() {
        List dgs = this.targetUtil.getDGForInstance(this.fromServer);
        if (dgs == null) {
            return localStrings.getString("migrate.timers.fromServerNotDG", (Object)this.fromServer);
        }
        if (this.isServerRunning(this.fromServer)) {
            return localStrings.getString("migrate.timers.migrateFromServerStillRunning", (Object)this.fromServer);
        }
        if (this.target.equals("server")) {
            List instances = ((DeploymentGroup)dgs.get(0)).getInstances();
            for (Server instance : instances) {
                if (!instance.isRunning()) continue;
                this.target = instance.getName();
                this.needRedirect = true;
            }
            if (this.target.equals("server")) {
                return localStrings.getString("migrate.timers.noRunningInstanceToChoose", (Object)this.target);
            }
        } else {
            boolean inSameDG = false;
            block1: for (DeploymentGroup dg : dgs) {
                for (Server instance : dg.getInstances()) {
                    if (!instance.getName().equals(this.target)) continue;
                    inSameDG = true;
                    continue block1;
                }
            }
            if (!inSameDG) {
                return localStrings.getString("migrate.timers.destinationIsNotInDG", (Object)this.target);
            }
            if (!this.isServerRunning(this.target)) {
                return localStrings.getString("migrate.timers.destinationServerIsNotAlive", (Object)this.target);
            }
        }
        return null;
    }
}

