/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.remote.reader;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.sun.enterprise.admin.remote.reader.ProprietaryReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import org.glassfish.api.admin.progress.ProgressStatusEvent;
import org.glassfish.api.admin.progress.ProgressStatusEventComplete;
import org.glassfish.api.admin.progress.ProgressStatusEventCreateChild;
import org.glassfish.api.admin.progress.ProgressStatusEventProgress;
import org.glassfish.api.admin.progress.ProgressStatusEventSet;

public class ProgressStatusEventJsonProprietaryReader
implements ProprietaryReader<ProgressStatusEvent> {
    private static final JsonFactory factory = new JsonFactory();

    @Override
    public boolean isReadable(Class<?> type, String mimetype) {
        return type.isAssignableFrom(ProgressStatusEvent.class);
    }

    public ProgressStatusEvent readFrom(HttpURLConnection urlConnection) throws IOException {
        return this.readFrom(urlConnection.getInputStream(), urlConnection.getContentType());
    }

    @Override
    public ProgressStatusEvent readFrom(InputStream is, String contentType) throws IOException {
        try (JsonParser jp = factory.createJsonParser(is);){
            JsonToken token = jp.nextToken();
            jp.nextToken();
            JsonToken token2 = jp.nextToken();
            if (token != JsonToken.START_OBJECT || token2 != JsonToken.START_OBJECT || !"progress-status-event".equals(jp.getCurrentName())) {
                throw new IOException("Not expected type (progress-status-event) but (" + jp.getCurrentName() + ")");
            }
            ProgressStatusEvent progressStatusEvent = ProgressStatusEventJsonProprietaryReader.readProgressStatusEvent(jp);
            return progressStatusEvent;
        }
    }

    public static ProgressStatusEvent readProgressStatusEvent(JsonParser jp) throws IOException {
        String id = null;
        JsonToken token = null;
        ProgressStatusEventSet result = null;
        while ((token = jp.nextToken()) != JsonToken.END_OBJECT) {
            if (token == JsonToken.START_OBJECT) {
                String nm = jp.getCurrentName();
                if (null == nm) continue;
                switch (nm) {
                    case "set": {
                        result = new ProgressStatusEventSet(id);
                        ProgressStatusEventJsonProprietaryReader.readToPSEventSet(result, jp);
                        break;
                    }
                    case "progres": {
                        result = new ProgressStatusEventProgress(id);
                        ProgressStatusEventJsonProprietaryReader.readToPSEventProgress((ProgressStatusEventProgress)result, jp);
                        break;
                    }
                    case "complete": {
                        result = new ProgressStatusEventComplete(id);
                        ProgressStatusEventJsonProprietaryReader.readToPSEventComplete((ProgressStatusEventComplete)result, jp);
                        break;
                    }
                    case "create-child": {
                        result = new ProgressStatusEventCreateChild(id);
                        ProgressStatusEventJsonProprietaryReader.readToPSEventCreateChild((ProgressStatusEventCreateChild)result, jp);
                        break;
                    }
                }
                continue;
            }
            String fieldname = jp.getCurrentName();
            if (!"id".equals(fieldname)) continue;
            jp.nextToken();
            id = jp.getText();
        }
        return result;
    }

    public static void readToPSEventSet(ProgressStatusEventSet event, JsonParser jp) throws IOException {
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldname = jp.getCurrentName();
            jp.nextToken();
            if ("total-step-count".equals(fieldname)) {
                event.setTotalStepCount(Integer.valueOf(jp.getIntValue()));
                continue;
            }
            if (!"current-step-count".equals(fieldname)) continue;
            event.setCurrentStepCount(Integer.valueOf(jp.getIntValue()));
        }
    }

    public static void readToPSEventProgress(ProgressStatusEventProgress event, JsonParser jp) throws IOException {
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldname = jp.getCurrentName();
            jp.nextToken();
            if (null == fieldname) continue;
            switch (fieldname) {
                case "steps": {
                    event.setSteps(jp.getIntValue());
                    break;
                }
                case "message": {
                    event.setMessage(jp.getText());
                    break;
                }
                case "spinner": {
                    event.setSpinner(jp.getBooleanValue());
                    break;
                }
            }
        }
    }

    public static void readToPSEventComplete(ProgressStatusEventComplete event, JsonParser jp) throws IOException {
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldname = jp.getCurrentName();
            jp.nextToken();
            if (!"message".equals(fieldname)) continue;
            event.setMessage(jp.getText());
        }
    }

    public static void readToPSEventCreateChild(ProgressStatusEventCreateChild event, JsonParser jp) throws IOException {
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldname = jp.getCurrentName();
            jp.nextToken();
            if (null == fieldname) continue;
            switch (fieldname) {
                case "id": {
                    event.setChildId(jp.getText());
                    break;
                }
                case "allocated-steps": {
                    event.setAllocatedSteps(jp.getIntValue());
                    break;
                }
                case "total-step-count": {
                    event.setTotalSteps(jp.getIntValue());
                    break;
                }
                case "name": {
                    event.setName(jp.getText());
                    break;
                }
            }
        }
    }
}

