/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.util.TokenValue;
import com.sun.enterprise.admin.util.TokenValueSet;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LineTokenReplacer {
    private final TokenValue[] tokenArray;
    private final String charsetName;

    public LineTokenReplacer(TokenValueSet tokens) {
        this(tokens, null);
    }

    public LineTokenReplacer(TokenValueSet tokens, String charset) {
        Object[] tmp = tokens.toArray();
        int length = tmp.length;
        this.tokenArray = new TokenValue[length];
        System.arraycopy(tmp, 0, this.tokenArray, 0, length);
        this.charsetName = charset;
    }

    public Reader getReader(final Reader in) {
        return new Reader(){
            BufferedReader reader;
            String line;
            final String eol;
            {
                this.reader = new BufferedReader(in);
                this.line = null;
                this.eol = System.getProperty("line.separator");
            }

            @Override
            public int read(char[] cbuf, int off, int len) throws IOException {
                int copySize;
                if (this.line == null || this.line.isEmpty()) {
                    this.line = this.reader.readLine();
                    if (this.line == null) {
                        return -1;
                    }
                    this.line = LineTokenReplacer.this.replaceLine(this.line) + this.eol;
                }
                if ((copySize = len - off) > this.line.length()) {
                    copySize = this.line.length();
                }
                this.line.getChars(0, copySize, cbuf, off);
                this.line = this.line.substring(copySize);
                return copySize;
            }

            @Override
            public void close() throws IOException {
                this.reader.close();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(File inputFile, File outputFile) {
        try (BufferedReader reader = new BufferedReader(new FileReader(inputFile));){
            BufferedWriter writer = null;
            FileOutputStream outputStream = null;
            try {
                String lineContents;
                if (this.charsetName != null) {
                    outputStream = new FileOutputStream(outputFile);
                    Charset charset = Charset.forName(this.charsetName);
                    writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, charset));
                } else {
                    writer = new BufferedWriter(new FileWriter(outputFile));
                }
                while ((lineContents = reader.readLine()) != null) {
                    String modifiedLine = this.replaceLine(lineContents);
                    writer.write(modifiedLine);
                    writer.newLine();
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(LineTokenReplacer.class.getPackage().getName()).log(Level.SEVERE, null, e);
            throw new RuntimeException(e);
        }
    }

    public void replace(String inputFileName, String outputFileName) {
        this.replace(new File(inputFileName), new File(outputFileName));
    }

    private String replaceLine(String lineWithTokens) {
        String tokenFreeString = lineWithTokens;
        for (TokenValue aPair : this.tokenArray) {
            tokenFreeString = tokenFreeString.replace(aPair.delimitedToken, aPair.value);
        }
        return tokenFreeString;
    }
}

