/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.config;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipAdapter;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.core.ReplicatedMap;
import fish.payara.nucleus.hazelcast.HazelcastCore;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service
@RunLevel(value=10)
public class ClusteredConfig
extends MembershipAdapter {
    private static final String CONFIGURATION_PREFIX = "fish.payara.config:";
    @Inject
    private HazelcastCore hzCore;
    private String membershipListenerRegistrationId;
    private final Set<String> sharedConfigurations = ConcurrentHashMap.newKeySet();

    @PostConstruct
    public void postConstruct() {
        HazelcastInstance hzInstance = this.hzCore.getInstance();
        if (hzInstance != null) {
            this.membershipListenerRegistrationId = hzInstance.getCluster().addMembershipListener((MembershipListener)this);
        }
    }

    @PreDestroy
    public void preDestroy() {
        HazelcastInstance hzInstance = this.hzCore.getInstance();
        if (hzInstance != null && this.membershipListenerRegistrationId != null) {
            hzInstance.getCluster().removeMembershipListener(this.membershipListenerRegistrationId);
        }
    }

    public <T extends Number> T getSharedConfiguration(String name, T localValue, BiFunction<T, T, T> merge) {
        HazelcastInstance hzInstance = this.hzCore.getInstance();
        if (hzInstance == null) {
            return localValue;
        }
        String instance = ClusteredConfig.instanceName(hzInstance.getCluster().getLocalMember());
        String mapName = CONFIGURATION_PREFIX + name;
        this.sharedConfigurations.add(mapName);
        ReplicatedMap map = hzInstance.getReplicatedMap(mapName);
        map.put((Object)instance, localValue);
        Object res = localValue;
        for (Number e : map.values()) {
            res = (Number)merge.apply(res, e);
        }
        return res;
    }

    public void clearSharedConfiguration(String name) {
        HazelcastInstance hzInstance = this.hzCore.getInstance();
        if (hzInstance != null) {
            String instance = ClusteredConfig.instanceName(hzInstance.getCluster().getLocalMember());
            String mapName = CONFIGURATION_PREFIX + name;
            hzInstance.getReplicatedMap(mapName).remove((Object)instance);
        }
    }

    public void memberRemoved(MembershipEvent event) {
        String instance = ClusteredConfig.instanceName(event.getMember());
        for (String mapName : this.sharedConfigurations) {
            this.hzCore.getInstance().getReplicatedMap(mapName).remove((Object)instance);
        }
    }

    private static String instanceName(Member member) {
        return member.getStringAttribute("GLASSFISH-INSTANCE");
    }
}

