/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.hazelcast;

import com.hazelcast.nio.Address;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import com.hazelcast.spi.discovery.integration.DiscoveryService;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.util.io.InstanceDirs;
import fish.payara.nucleus.hazelcast.HazelcastRuntimeConfiguration;
import fish.payara.nucleus.hazelcast.MemberAddressPicker;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.grizzly.utils.Holder;
import org.glassfish.internal.api.Globals;
import org.glassfish.internal.api.ServerContext;

public class DomainDiscoveryService
implements DiscoveryService {
    private static Logger logger = Logger.getLogger(DomainDiscoveryService.class.getName());
    private final Holder.LazyHolder<InetAddress> chosenAddress = Holder.LazyHolder.lazyHolder(MemberAddressPicker::findMyAddress);

    public void start() {
    }

    public Iterable<DiscoveryNode> discoverNodes() {
        LinkedList<DiscoveryNode> nodes;
        block21: {
            logger.fine("Starting Domain Node Discovery");
            nodes = new LinkedList<DiscoveryNode>();
            Domain domain = (Domain)Globals.getDefaultHabitat().getService(Domain.class, new Annotation[0]);
            ServerContext ctxt = (ServerContext)Globals.getDefaultHabitat().getService(ServerContext.class, new Annotation[0]);
            ServerEnvironment env = (ServerEnvironment)Globals.getDefaultHabitat().getService(ServerEnvironment.class, new Annotation[0]);
            HazelcastRuntimeConfiguration hzConfig = (HazelcastRuntimeConfiguration)domain.getExtensionByType(HazelcastRuntimeConfiguration.class);
            if (!env.isDas()) {
                try {
                    logger.fine("This is a Standalone Instance");
                    String dasHost = hzConfig.getDASPublicAddress();
                    if (dasHost == null || dasHost.isEmpty()) {
                        dasHost = hzConfig.getDASBindAddress();
                    }
                    if ((dasHost = Optional.ofNullable(MemberAddressPicker.initAddress(dasHost, 0)).map(InetSocketAddress::getHostString).orElse("")).isEmpty()) {
                        logger.fine("Neither DAS Public Address or Bind Address is set in the configuration");
                        InstanceDirs instance = new InstanceDirs(env.getInstanceRoot());
                        Properties dasProps = new Properties();
                        dasProps.load(new FileInputStream(instance.getDasPropertiesFile()));
                        logger.fine("Loaded the das.properties file from the agent directory");
                        dasHost = dasProps.getProperty("agent.das.host");
                        dasHost = InetAddress.getByName(dasHost).getHostAddress();
                        logger.log(Level.FINE, "Loaded the das.properties file from the agent directory and found DAS IP {0}", dasHost);
                    }
                    if (dasHost.isEmpty() || dasHost.equals("127.0.0.1") || dasHost.equals("localhost")) {
                        logger.fine("Looks like the DAS IP is loopback or empty let's find the actual IP of this machine as that is where the DAS is");
                        nodes.add((DiscoveryNode)new SimpleDiscoveryNode(new Address((InetAddress)this.chosenAddress.get(), Integer.parseInt(hzConfig.getDasPort()))));
                    } else {
                        logger.log(Level.FINE, "DAS should be listening on {0}", dasHost);
                        nodes.add((DiscoveryNode)new SimpleDiscoveryNode(new Address(dasHost, Integer.valueOf(hzConfig.getDasPort()).intValue())));
                    }
                    logger.fine("Also adding all known domain nodes and start ports in case the DAS is down");
                    for (Node node : domain.getNodes().getNode()) {
                        InetAddress address = InetAddress.getByName(node.getNodeHost());
                        if (address.isLoopbackAddress()) continue;
                        logger.log(Level.FINE, "Adding Node {0}", address);
                        nodes.add((DiscoveryNode)new SimpleDiscoveryNode(new Address(address.getHostAddress(), Integer.valueOf(hzConfig.getStartPort()).intValue())));
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(DomainDiscoveryService.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else if (env.isMicro()) {
                try {
                    logger.log(Level.FINE, "We are Payara Micro therefore adding DAS {0}", hzConfig.getDASPublicAddress());
                    String dasHost = Optional.ofNullable(MemberAddressPicker.initAddress(hzConfig.getDASPublicAddress(), 0)).map(InetSocketAddress::getHostString).orElse("");
                    if (hzConfig.getDasPort().equals("4848")) {
                        logger.log(Level.WARNING, "You have specified 4848 as the datagrid domain port however this is the default DAS admin port, the default domain datagrid port is 4900");
                    }
                    if (dasHost.isEmpty() || dasHost.equals("127.0.0.1") || dasHost.equals("localhost")) {
                        nodes.add((DiscoveryNode)new SimpleDiscoveryNode(new Address((InetAddress)this.chosenAddress.get(), Integer.parseInt(hzConfig.getDasPort()))));
                        break block21;
                    }
                    nodes.add((DiscoveryNode)new SimpleDiscoveryNode(new Address(InetAddress.getByName(dasHost), Integer.valueOf(hzConfig.getDasPort()).intValue())));
                }
                catch (NumberFormatException | UnknownHostException ex) {
                    Logger.getLogger(DomainDiscoveryService.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                logger.fine("We are the DAS therefore we will add all known nodes with start port as IP addresses to connect to");
                if (domain.getNodes() == null) {
                    nodes.add((DiscoveryNode)new SimpleDiscoveryNode(new Address((InetAddress)this.chosenAddress.get(), Integer.parseInt(hzConfig.getStartPort()))));
                } else {
                    for (Node node : domain.getNodes().getNode()) {
                        try {
                            InetAddress address = InetAddress.getByName(node.getNodeHost());
                            if (!address.isLoopbackAddress()) {
                                logger.log(Level.FINE, "Adding Node {0}", address);
                                nodes.add((DiscoveryNode)new SimpleDiscoveryNode(new Address(address.getHostAddress(), Integer.valueOf(hzConfig.getStartPort()).intValue())));
                                continue;
                            }
                            nodes.add((DiscoveryNode)new SimpleDiscoveryNode(new Address((InetAddress)this.chosenAddress.get(), Integer.parseInt(hzConfig.getStartPort()))));
                        }
                        catch (IOException ex) {
                            Logger.getLogger(DomainDiscoveryService.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
            }
        }
        return nodes;
    }

    public void destroy() {
    }

    public Map<String, Object> discoverLocalMetadata() {
        return Collections.emptyMap();
    }
}

