/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.hazelcast;

import com.hazelcast.cache.impl.HazelcastServerCachingProvider;
import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigLoader;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.GlobalSerializerConfig;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.KubernetesConfig;
import com.hazelcast.config.MemberAddressProviderConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.PartitionGroupConfig;
import com.hazelcast.config.ScheduledExecutorConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import com.hazelcast.kubernetes.KubernetesProperties;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.StreamSerializer;
import com.hazelcast.spi.MemberAddressProvider;
import com.hazelcast.spi.discovery.integration.DiscoveryServiceProvider;
import com.sun.enterprise.util.Utility;
import fish.payara.nucleus.events.HazelcastEvents;
import fish.payara.nucleus.hazelcast.DnsDiscoveryServiceProvider;
import fish.payara.nucleus.hazelcast.DomainDiscoveryServiceProvider;
import fish.payara.nucleus.hazelcast.HazelcastConfigSpecificConfiguration;
import fish.payara.nucleus.hazelcast.HazelcastRuntimeConfiguration;
import fish.payara.nucleus.hazelcast.MemberAddressPicker;
import fish.payara.nucleus.hazelcast.PayaraHazelcastSerializer;
import fish.payara.nucleus.hazelcast.PayaraMicroNameGenerator;
import fish.payara.nucleus.hazelcast.contextproxy.CachingProviderProxy;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.cache.spi.CachingProvider;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.JavaEEContextUtil;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.Transactions;
import org.jvnet.hk2.config.UnprocessedChangeEvent;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service(name="hazelcast-core")
@RunLevel(value=10)
public class HazelcastCore
implements EventListener,
ConfigListener {
    public static final String INSTANCE_ATTRIBUTE = "GLASSFISH-INSTANCE";
    public static final String INSTANCE_GROUP_ATTRIBUTE = "GLASSFISH_INSTANCE_GROUP";
    public static final String CLUSTER_EXECUTOR_SERVICE_NAME = "payara-cluster-execution";
    public static final String SCHEDULED_CLUSTER_EXECUTOR_SERVICE_NAME = "payara-scheduled-execution";
    private static HazelcastCore theCore;
    private HazelcastInstance theInstance;
    private CachingProvider hazelcastCachingProvider;
    private boolean enabled;
    private boolean booted = false;
    private String memberName;
    private String memberGroup;
    private boolean datagridEncryptionValue;
    @Inject
    Events events;
    @Inject
    ServerContext context;
    @Inject
    ServerEnvironment env;
    @Inject
    HazelcastRuntimeConfiguration configuration;
    @Inject
    HazelcastConfigSpecificConfiguration nodeConfig;
    @Inject
    private ClassLoaderHierarchy clh;
    @Inject
    @Optional
    private JavaEEContextUtil ctxUtil;
    @Inject
    Transactions transactions;

    public static HazelcastCore getCore() {
        return theCore;
    }

    @PostConstruct
    public void postConstruct() {
        theCore = this;
        this.events.register((EventListener)this);
        this.enabled = Boolean.valueOf(this.nodeConfig.getEnabled());
        this.transactions.addListenerForType(HazelcastConfigSpecificConfiguration.class, (ConfigListener)this);
        this.transactions.addListenerForType(HazelcastRuntimeConfiguration.class, (ConfigListener)this);
        if (this.env.isMicro()) {
            this.memberName = this.nodeConfig.getMemberName();
            this.memberGroup = this.nodeConfig.getMemberGroup();
        } else {
            this.memberName = this.context.getInstanceName();
            this.memberGroup = this.nodeConfig.getMemberGroup();
        }
        this.datagridEncryptionValue = Boolean.parseBoolean(this.configuration.getDatagridEncryptionEnabled());
        if (this.datagridEncryptionValue) {
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "Data grid encryption is enabled");
        }
    }

    public String getMemberName() {
        return this.memberName;
    }

    public String getMemberGroup() {
        return this.memberGroup;
    }

    public String getUUID() {
        this.bootstrapHazelcast();
        if (!this.enabled) {
            return UUID.randomUUID().toString();
        }
        return this.theInstance.getCluster().getLocalMember().getUuid();
    }

    public boolean isLite() {
        this.bootstrapHazelcast();
        if (!this.enabled) {
            return false;
        }
        return this.theInstance.getCluster().getLocalMember().isLiteMember();
    }

    public HazelcastInstance getInstance() {
        this.bootstrapHazelcast();
        return this.theInstance;
    }

    public CachingProvider getCachingProvider() {
        this.bootstrapHazelcast();
        return this.hazelcastCachingProvider;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void event(EventListener.Event event) {
        if (event.is(Deployment.ALL_APPLICATIONS_STOPPED)) {
            this.shutdownHazelcast();
        } else if (event.is(Deployment.ALL_APPLICATIONS_LOADED)) {
            ClassLoader oldCL = Utility.getClassLoader();
            try {
                Utility.setContextClassLoader((ClassLoader)this.clh.getCommonClassLoader());
                this.bootstrapHazelcast();
            }
            finally {
                Utility.setContextClassLoader((ClassLoader)oldCL);
            }
        } else if (event.is(EventTypes.SERVER_STARTUP) && this.isEnabled() && this.booted) {
            this.events.send(new EventListener.Event(HazelcastEvents.HAZELCAST_BOOTSTRAP_COMPLETE));
        }
    }

    public void setEnabled(Boolean enabled) {
        if (this.enabled || enabled.booleanValue()) {
            if (this.enabled && !enabled.booleanValue()) {
                this.enabled = false;
                this.shutdownHazelcast();
                this.booted = false;
            } else if (!this.enabled && enabled.booleanValue()) {
                this.enabled = true;
                this.bootstrapHazelcast();
            } else if (this.enabled && enabled.booleanValue()) {
                this.shutdownHazelcast();
                this.enabled = true;
                this.booted = false;
                this.bootstrapHazelcast();
            }
        }
    }

    private Config buildConfiguration() {
        Config config = new Config();
        String hazelcastFilePath = "";
        try {
            URL serverConfigURL = new URL(this.context.getServerConfigURL());
            File serverConfigFile = new File(serverConfigURL.getPath());
            hazelcastFilePath = serverConfigFile.getParentFile().getAbsolutePath() + File.separator + this.configuration.getHazelcastConfigurationFile();
            File file = new File(hazelcastFilePath);
            if (file.exists()) {
                config = ConfigLoader.load((String)hazelcastFilePath);
                if (config == null) {
                    Logger.getLogger(HazelcastCore.class.getName()).log(Level.WARNING, "Hazelcast Core could not find configuration file {0} using default configuration", hazelcastFilePath);
                    config = new Config();
                }
                config.setClassLoader(this.clh.getCommonClassLoader());
                if (this.ctxUtil == null) {
                    Logger.getLogger(HazelcastCore.class.getName()).log(Level.WARNING, "Hazelcast Application Object Serialization Not Available");
                } else {
                    SerializationConfig serConfig = config.getSerializationConfig();
                    if (serConfig == null) {
                        serConfig = new SerializationConfig();
                        this.setPayaraSerializerConfig(serConfig);
                        config.setSerializationConfig(serConfig);
                    } else if (serConfig.getGlobalSerializerConfig() == null) {
                        this.setPayaraSerializerConfig(serConfig);
                    } else {
                        Serializer ser = serConfig.getGlobalSerializerConfig().getImplementation();
                        if (ser instanceof StreamSerializer) {
                            config.getSerializationConfig().getGlobalSerializerConfig().setImplementation((Serializer)new PayaraHazelcastSerializer(this.ctxUtil, (StreamSerializer)ser));
                        } else {
                            Logger.getLogger(HazelcastCore.class.getName()).log(Level.WARNING, "Global serializer is not StreamSerializer: {0}", ser.getClass().getName());
                        }
                    }
                }
            } else {
                config.setClassLoader(this.clh.getCommonClassLoader());
                if (this.ctxUtil != null) {
                    SerializationConfig serializationConfig = new SerializationConfig();
                    this.setPayaraSerializerConfig(serializationConfig);
                    config.setSerializationConfig(serializationConfig);
                }
                this.buildNetworkConfiguration(config);
                config.setLicenseKey(this.configuration.getLicenseKey());
                config.setLiteMember(Boolean.parseBoolean(this.nodeConfig.getLite()));
                GroupConfig gc = config.getGroupConfig();
                gc.setName(this.configuration.getClusterGroupName());
                gc.setPassword(this.configuration.getClusterGroupPassword());
                if ("true".equals(this.configuration.getHostAwarePartitioning())) {
                    PartitionGroupConfig partitionGroupConfig = config.getPartitionGroupConfig();
                    partitionGroupConfig.setEnabled(this.enabled);
                    partitionGroupConfig.setGroupType(PartitionGroupConfig.MemberGroupType.HOST_AWARE);
                }
                ExecutorConfig executorConfig = config.getExecutorConfig(CLUSTER_EXECUTOR_SERVICE_NAME);
                executorConfig.setStatisticsEnabled(true);
                executorConfig.setPoolSize(Integer.valueOf(this.nodeConfig.getExecutorPoolSize()).intValue());
                executorConfig.setQueueCapacity(Integer.valueOf(this.nodeConfig.getExecutorQueueCapacity()).intValue());
                ScheduledExecutorConfig scheduledExecutorConfig = config.getScheduledExecutorConfig(SCHEDULED_CLUSTER_EXECUTOR_SERVICE_NAME);
                scheduledExecutorConfig.setDurability(1);
                scheduledExecutorConfig.setCapacity(Integer.valueOf(this.nodeConfig.getScheduledExecutorQueueCapacity()).intValue());
                scheduledExecutorConfig.setPoolSize(Integer.valueOf(this.nodeConfig.getScheduledExecutorPoolSize()).intValue());
                config.setProperty("hazelcast.jmx", "true");
            }
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.WARNING, "Unable to parse server config URL", ex);
        }
        catch (IOException ex) {
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.WARNING, "Hazelcast Core could not load configuration file " + hazelcastFilePath + " using default configuration", ex);
        }
        return config;
    }

    private void setPayaraSerializerConfig(SerializationConfig serConfig) {
        if (serConfig == null || this.ctxUtil == null) {
            throw new IllegalStateException("either serialization config or ctxUtil is null");
        }
        serConfig.setGlobalSerializerConfig(new GlobalSerializerConfig().setImplementation((Serializer)new PayaraHazelcastSerializer(this.ctxUtil, null)).setOverrideJavaSerialization(true));
    }

    private void buildNetworkConfiguration(Config config) throws NumberFormatException {
        String discoveryMode;
        int configSpecificPortInt;
        NetworkConfig nConfig = config.getNetworkConfig();
        if (this.nodeConfig.getPublicAddress() != null && !this.nodeConfig.getPublicAddress().isEmpty()) {
            nConfig.setPublicAddress(this.nodeConfig.getPublicAddress());
        }
        if (!this.configuration.getInterface().isEmpty()) {
            String[] interfaceNames;
            for (String interfaceName : interfaceNames = this.configuration.getInterface().split(",")) {
                nConfig.getInterfaces().addInterface(interfaceName.trim());
            }
            nConfig.getInterfaces().setEnabled(true);
        } else {
            MemberAddressProviderConfig memberAddressProviderConfig = nConfig.getMemberAddressProviderConfig();
            memberAddressProviderConfig.setEnabled(this.enabled);
            memberAddressProviderConfig.setImplementation((MemberAddressProvider)new MemberAddressPicker(this.env, this.configuration, this.nodeConfig));
        }
        int port = Integer.valueOf(this.configuration.getStartPort());
        String configSpecificPort = this.nodeConfig.getConfigSpecificDataGridStartPort();
        if (configSpecificPort != null && !configSpecificPort.isEmpty() && (configSpecificPortInt = Integer.parseInt(configSpecificPort)) != 0) {
            port = configSpecificPortInt;
        }
        if ((discoveryMode = this.configuration.getDiscoveryMode()).startsWith("tcpip")) {
            TcpIpConfig tConfig = config.getNetworkConfig().getJoin().getTcpIpConfig();
            tConfig.setEnabled(true);
            tConfig.addMember(this.configuration.getTcpipMembers());
            config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
        } else if (discoveryMode.startsWith("dns")) {
            config.setProperty("hazelcast.discovery.enabled", "true");
            config.getNetworkConfig().getJoin().getDiscoveryConfig().setDiscoveryServiceProvider((DiscoveryServiceProvider)new DnsDiscoveryServiceProvider(this.configuration.getDnsMembers()));
            config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
        } else if (discoveryMode.startsWith("multicast")) {
            MulticastConfig mcConfig = config.getNetworkConfig().getJoin().getMulticastConfig();
            mcConfig.setEnabled(true);
            mcConfig.setMulticastGroup(this.configuration.getMulticastGroup());
            mcConfig.setMulticastPort(Integer.valueOf(this.configuration.getMulticastPort()).intValue());
        } else if (discoveryMode.startsWith("kubernetes")) {
            config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
            ((KubernetesConfig)((KubernetesConfig)((KubernetesConfig)config.getNetworkConfig().getJoin().getKubernetesConfig().setEnabled(true)).setProperty(KubernetesProperties.NAMESPACE.key(), this.configuration.getKubernetesNamespace())).setProperty(KubernetesProperties.SERVICE_NAME.key(), this.configuration.getKubernetesServiceName())).setProperty(KubernetesProperties.SERVICE_PORT.key(), String.valueOf(port));
        } else {
            config.setProperty("hazelcast.discovery.enabled", "true");
            config.getNetworkConfig().getJoin().getDiscoveryConfig().setDiscoveryServiceProvider((DiscoveryServiceProvider)new DomainDiscoveryServiceProvider());
            config.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
        }
        if (this.env.isDas() && !this.env.isMicro()) {
            port = Integer.valueOf(this.configuration.getDasPort());
        }
        config.getNetworkConfig().setPort(port);
        config.getNetworkConfig().setPortAutoIncrement("true".equalsIgnoreCase(this.configuration.getAutoIncrementPort()));
    }

    private void shutdownHazelcast() {
        if (this.theInstance != null) {
            this.enabled = false;
            this.events.send(new EventListener.Event(HazelcastEvents.HAZELCAST_SHUTDOWN_STARTED, (Object)true));
            this.unbindFromJNDI();
            this.hazelcastCachingProvider.getCacheManager().close();
            this.hazelcastCachingProvider.close();
            this.theInstance.shutdown();
            this.theInstance = null;
            this.events.send(new EventListener.Event(HazelcastEvents.HAZELCAST_SHUTDOWN_COMPLETE));
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "Shutdown Hazelcast");
        }
    }

    private synchronized void bootstrapHazelcast() {
        if (!this.booted && this.isEnabled()) {
            Config config = this.buildConfiguration();
            this.theInstance = Hazelcast.newHazelcastInstance((Config)config);
            if (this.env.isMicro() && (Boolean.valueOf(this.configuration.getGenerateNames()).booleanValue() || this.memberName == null)) {
                this.memberName = PayaraMicroNameGenerator.generateName();
                Set clusterMembers = this.theInstance.getCluster().getMembers();
                ArrayList<String> takenNames = new ArrayList<String>();
                for (Member member : clusterMembers) {
                    if (member == this.theInstance.getCluster().getLocalMember() || member.getStringAttribute(INSTANCE_GROUP_ATTRIBUTE) == null || !member.getStringAttribute(INSTANCE_GROUP_ATTRIBUTE).equalsIgnoreCase(this.memberGroup)) continue;
                    takenNames.add(member.getStringAttribute(INSTANCE_ATTRIBUTE));
                }
                if (takenNames.contains(this.memberName)) {
                    this.memberName = PayaraMicroNameGenerator.generateUniqueName(takenNames, this.theInstance.getCluster().getLocalMember().getUuid());
                    this.theInstance.getCluster().getLocalMember().setStringAttribute(INSTANCE_ATTRIBUTE, this.memberName);
                }
            }
            this.theInstance.getCluster().getLocalMember().setStringAttribute(INSTANCE_ATTRIBUTE, this.memberName);
            this.theInstance.getCluster().getLocalMember().setStringAttribute(INSTANCE_GROUP_ATTRIBUTE, this.memberGroup);
            this.hazelcastCachingProvider = new CachingProviderProxy((CachingProvider)HazelcastServerCachingProvider.createCachingProvider((HazelcastInstance)this.theInstance), this.context);
            this.bindToJNDI();
            if (this.env.getStatus() == ServerEnvironment.Status.started) {
                this.events.send(new EventListener.Event(HazelcastEvents.HAZELCAST_BOOTSTRAP_COMPLETE));
            }
            this.booted = true;
        }
    }

    private void bindToJNDI() {
        try {
            InitialContext ctx = new InitialContext();
            ctx.bind(this.nodeConfig.getJNDIName(), (Object)this.theInstance);
            ctx.bind(this.nodeConfig.getCachingProviderJNDIName(), (Object)this.hazelcastCachingProvider);
            ctx.bind(this.nodeConfig.getCacheManagerJNDIName(), (Object)this.hazelcastCachingProvider.getCacheManager());
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "Hazelcast Instance Bound to JNDI at {0}", this.nodeConfig.getJNDIName());
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "JSR107 Caching Provider Bound to JNDI at {0}", this.nodeConfig.getCachingProviderJNDIName());
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "JSR107 Default Cache Manager Bound to JNDI at {0}", this.nodeConfig.getCacheManagerJNDIName());
        }
        catch (NamingException ex) {
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void unbindFromJNDI() {
        try {
            InitialContext ctx = new InitialContext();
            ctx.unbind(this.nodeConfig.getJNDIName());
            ctx.unbind(this.nodeConfig.getCacheManagerJNDIName());
            ctx.unbind(this.nodeConfig.getCachingProviderJNDIName());
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "Hazelcast Instance Unbound from JNDI at {0}", this.nodeConfig.getJNDIName());
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "JSR107 Caching Provider Unbound from JNDI at {0}", this.nodeConfig.getCachingProviderJNDIName());
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.INFO, "JSR107 Cache Manager Unbound from JNDI at {0}", this.nodeConfig.getCacheManagerJNDIName());
        }
        catch (NamingException ex) {
            Logger.getLogger(HazelcastCore.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public int getPort() {
        return this.theInstance.getCluster().getLocalMember().getSocketAddress().getPort();
    }

    public UnprocessedChangeEvents changed(PropertyChangeEvent[] pces) {
        ArrayList<UnprocessedChangeEvent> unprocessedChanges = new ArrayList<UnprocessedChangeEvent>();
        for (PropertyChangeEvent pce : pces) {
            if (!pce.getPropertyName().equalsIgnoreCase("datagrid-encryption-enabled")) continue;
            unprocessedChanges.add(new UnprocessedChangeEvent(pce, "Hazelcast encryption settings changed"));
        }
        if (unprocessedChanges.isEmpty()) {
            return null;
        }
        return new UnprocessedChangeEvents(unprocessedChanges);
    }

    public boolean isDatagridEncryptionEnabled() {
        return this.datagridEncryptionValue;
    }
}

