/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.hazelcast.contextproxy;

import java.util.Collection;
import java.util.Map;
import javax.cache.Cache;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriter;
import javax.cache.integration.CacheWriterException;
import org.glassfish.internal.api.JavaEEContextUtil;

class CompleteConfigurationProxy<K, V>
extends MutableConfiguration<K, V> {
    private final JavaEEContextUtil ctxUtil;
    private static final long serialVersionUID = 1L;

    public CompleteConfigurationProxy(CompleteConfiguration<K, V> config, JavaEEContextUtil ctxUtil) {
        super(config);
        this.ctxUtil = ctxUtil;
        this.init();
    }

    private void init() {
        if (this.cacheLoaderFactory != null) {
            this.cacheLoaderFactory = this.proxyLoader(this.cacheLoaderFactory);
        }
        if (this.cacheWriterFactory != null) {
            this.cacheWriterFactory = this.proxyWriter(this.cacheWriterFactory);
        }
    }

    private Factory<CacheLoader<K, V>> proxyLoader(final Factory<CacheLoader<K, V>> fact) {
        return new Factory<CacheLoader<K, V>>(){
            private static final long serialVersionUID = 1L;

            public CacheLoader<K, V> create() {
                try (JavaEEContextUtil.Context ctx = CompleteConfigurationProxy.this.ctxUtil.pushContext();){
                    CacheLoader loader = (CacheLoader)fact.create();
                    CacheLoaderImpl cacheLoaderImpl = new CacheLoaderImpl(loader);
                    return cacheLoaderImpl;
                }
            }

            class CacheLoaderImpl
            implements CacheLoader<K, V> {
                private final CacheLoader<K, V> loader;

                public CacheLoaderImpl(CacheLoader<K, V> loader) {
                    this.loader = loader;
                }

                public V load(K k) throws CacheLoaderException {
                    try (JavaEEContextUtil.Context context = CompleteConfigurationProxy.this.ctxUtil.pushRequestContext();){
                        Object object = this.loader.load(k);
                        return object;
                    }
                }

                public Map<K, V> loadAll(Iterable<? extends K> itrbl) throws CacheLoaderException {
                    try (JavaEEContextUtil.Context context = CompleteConfigurationProxy.this.ctxUtil.pushRequestContext();){
                        Map map = this.loader.loadAll(itrbl);
                        return map;
                    }
                }
            }
        };
    }

    private Factory<CacheWriter<? super K, ? super V>> proxyWriter(final Factory<CacheWriter<? super K, ? super V>> fact) {
        return new Factory<CacheWriter<? super K, ? super V>>(){
            private static final long serialVersionUID = 1L;

            public CacheWriter<K, V> create() {
                try (JavaEEContextUtil.Context ctx = CompleteConfigurationProxy.this.ctxUtil.pushContext();){
                    CacheWriter delegate = (CacheWriter)fact.create();
                    CacheWriterImpl cacheWriterImpl = new CacheWriterImpl(delegate);
                    return cacheWriterImpl;
                }
            }

            class CacheWriterImpl
            implements CacheWriter<K, V> {
                private final CacheWriter<K, V> delegate;

                public void write(Cache.Entry<? extends K, ? extends V> entry) throws CacheWriterException {
                    try (JavaEEContextUtil.Context context = CompleteConfigurationProxy.this.ctxUtil.pushRequestContext();){
                        this.delegate.write(entry);
                    }
                }

                public void writeAll(Collection<Cache.Entry<? extends K, ? extends V>> clctn) throws CacheWriterException {
                    try (JavaEEContextUtil.Context context = CompleteConfigurationProxy.this.ctxUtil.pushRequestContext();){
                        this.delegate.writeAll(clctn);
                    }
                }

                public void delete(Object o) throws CacheWriterException {
                    try (JavaEEContextUtil.Context context = CompleteConfigurationProxy.this.ctxUtil.pushRequestContext();){
                        this.delegate.delete(o);
                    }
                }

                public void deleteAll(Collection<?> clctn) throws CacheWriterException {
                    try (JavaEEContextUtil.Context context = CompleteConfigurationProxy.this.ctxUtil.pushRequestContext();){
                        this.delegate.deleteAll(clctn);
                    }
                }

                public CacheWriterImpl(CacheWriter<K, V> delegate) {
                    this.delegate = delegate;
                }
            }
        };
    }
}

