/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt;

import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainException;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryException;
import com.sun.enterprise.admin.servermgmt.SLogger;
import com.sun.enterprise.admin.servermgmt.pe.PEFileLayout;
import com.sun.enterprise.security.auth.realm.certificate.OID;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.util.ExecException;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.ProcessExecutor;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.net.NetUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class KeystoreManager {
    private static final String KEYTOOL_CMD;
    private static final String KEYTOOL_EXE_NAME;
    private static final String CERTIFICATE_DN_PREFIX = "CN=";
    private static final String CERTIFICATE_DN_SUFFIX = ",OU=Payara,O=Payara Foundation,L=Great Malvern,ST=Worcestershire,C=UK";
    public static final String CERTIFICATE_ALIAS = "s1as";
    public static final String INSTANCE_SECURE_ADMIN_ALIAS = "glassfish-instance";
    public static final String DEFAULT_MASTER_PASSWORD = "changeit";
    private static final String SKID_EXTENSION_SYSTEM_PROPERTY = "-J-Dsun.security.internal.keytool.skid";
    private static final String INSTANCE_CN_SUFFIX = "-instance";
    private static final StringManager STRING_MANAGER;
    protected PEFileLayout _fileLayout = null;

    protected static String getCertificateDN(RepositoryConfig cfg, String CNSuffix) {
        String cn = KeystoreManager.getCNFromCfg(cfg);
        if (cn == null) {
            try {
                cn = NetUtils.getCanonicalHostName();
            }
            catch (Exception e) {
                cn = "localhost";
            }
        }
        return CERTIFICATE_DN_PREFIX + cn + (CNSuffix != null ? CNSuffix : "") + CERTIFICATE_DN_SUFFIX;
    }

    protected PEFileLayout getFileLayout(RepositoryConfig config) {
        if (this._fileLayout == null) {
            this._fileLayout = new PEFileLayout(config);
        }
        return this._fileLayout;
    }

    protected void createKeyStore(File keystore, RepositoryConfig config, String masterPassword) throws RepositoryException {
        String dasCertDN = KeystoreManager.getDASCertDN(config);
        SLogger.getLogger().log(Level.INFO, STRING_MANAGER.getString("CertificateDN", (Object)dasCertDN));
        this.addSelfSignedCertToKeyStore(keystore, CERTIFICATE_ALIAS, masterPassword, dasCertDN);
        String instanceCertDN = KeystoreManager.getInstanceCertDN(config);
        SLogger.getLogger().log(Level.INFO, STRING_MANAGER.getString("CertificateDN", (Object)instanceCertDN));
        this.addSelfSignedCertToKeyStore(keystore, INSTANCE_SECURE_ADMIN_ALIAS, masterPassword, instanceCertDN);
    }

    private void addSelfSignedCertToKeyStore(File keystore, String alias, String masterPassword, String dn) throws RepositoryException {
        String[] keytoolCmd = new String[]{"-genkey", "-keyalg", "RSA", "-keystore", keystore.getAbsolutePath(), "-alias", alias, "-dname", dn, "-validity", "3650", "-keypass", masterPassword, "-storepass", masterPassword, SKID_EXTENSION_SYSTEM_PROPERTY};
        KeytoolExecutor p = new KeytoolExecutor(keytoolCmd, 60L);
        p.execute("keystoreNotCreated", keystore);
    }

    protected void copyCertificates(File keyStore, File trustStore, DomainConfig config, String masterPassword) throws DomainException {
        try {
            this.copyCert(keyStore, trustStore, CERTIFICATE_ALIAS, masterPassword);
            this.copyCert(keyStore, trustStore, INSTANCE_SECURE_ADMIN_ALIAS, masterPassword);
        }
        catch (RepositoryException re) {
            String msg = STRING_MANAGER.getString("SomeProblemWithKeytool", (Object)re.getMessage());
            throw new DomainException(msg);
        }
    }

    protected void updateCertificates(File trustStore, String masterPassword) throws RepositoryException {
        KeyStore destTrustStore;
        KeyStore javaTrustStore;
        String javaHome = System.getProperty("java.home").concat("/").replaceAll("//", "/");
        String jreHome = Files.exists(Paths.get(javaHome, "jre/"), new LinkOption[0]) ? javaHome + "jre/" : javaHome;
        String javaTrustStoreLocation = jreHome + "lib/security/";
        File javaTrustStoreFile = new File(javaTrustStoreLocation, "cacerts");
        try {
            FileInputStream javaIn = new FileInputStream(javaTrustStoreFile);
            Object object = null;
            try (FileInputStream fileInputStream = new FileInputStream(trustStore);){
                javaTrustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                javaTrustStore.load(javaIn, DEFAULT_MASTER_PASSWORD.toCharArray());
                destTrustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                destTrustStore.load(fileInputStream, masterPassword.toCharArray());
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (javaIn != null) {
                    if (object != null) {
                        try {
                            javaIn.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        javaIn.close();
                    }
                }
            }
        }
        catch (KeyStoreException ex) {
            throw new RepositoryException("Unable to create Keystore object.", ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RepositoryException("Unable to read Keystore file.", ex);
        }
        catch (CertificateException ex) {
            throw new RepositoryException("Unable to load certificate from Keystore instance.", ex);
        }
        catch (FileNotFoundException ex) {
            throw new RepositoryException("Unable to find Keystore file.", ex);
        }
        catch (IOException ex) {
            throw new RepositoryException("Unexpected exception reading Keystore file.", ex);
        }
        this.removeExpiredCerts(destTrustStore);
        Map<String, Certificate> validCerts = this.getValidCertificates(javaTrustStore);
        try {
            for (Map.Entry entry : validCerts.entrySet()) {
                Certificate cert = (Certificate)entry.getValue();
                if (destTrustStore.containsAlias((String)entry.getKey())) continue;
                destTrustStore.setCertificateEntry((String)entry.getKey(), cert);
            }
        }
        catch (KeyStoreException ex) {
            throw new RepositoryException("Keystore hasn't been initialized.", ex);
        }
        try {
            Throwable throwable = null;
            try (FileOutputStream out = new FileOutputStream(trustStore);){
                destTrustStore.store(out, masterPassword.toCharArray());
                out.flush();
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
            throw new RepositoryException("Unexpected exception writing certificates to the Keystore file.", ex);
        }
    }

    private void removeExpiredCerts(KeyStore store) throws RepositoryException {
        Map<String, Certificate> invalidCerts = this.getInvalidCertificates(store);
        for (Map.Entry<String, Certificate> alias : invalidCerts.entrySet()) {
            try {
                store.deleteEntry(alias.getKey());
            }
            catch (KeyStoreException ex) {
                throw new RepositoryException("Could not delete invalid cert", ex);
            }
        }
    }

    protected Map<String, Certificate> getValidCertificates(KeyStore keyStore) throws RepositoryException {
        return this.getCertificates(keyStore, true);
    }

    protected Map<String, Certificate> getInvalidCertificates(KeyStore keyStore) throws RepositoryException {
        return this.getCertificates(keyStore, false);
    }

    private Map<String, Certificate> getCertificates(KeyStore keyStore, boolean returnValidCerts) throws RepositoryException {
        HashMap<String, Certificate> certs = new HashMap<String, Certificate>();
        try {
            for (String alias : Collections.list(keyStore.aliases())) {
                Certificate cert = keyStore.getCertificate(alias);
                if (!cert.getType().equals("X.509")) continue;
                X509Certificate xCert = (X509Certificate)cert;
                try {
                    xCert.checkValidity();
                    if (!returnValidCerts) continue;
                    certs.put(alias, cert);
                }
                catch (CertificateExpiredException | CertificateNotYetValidException e) {
                    if (returnValidCerts) continue;
                    certs.put(alias, cert);
                }
            }
        }
        catch (KeyStoreException ex) {
            throw new RepositoryException("Keystore hasn't been initialized.", ex);
        }
        return certs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyCert(File keyStore, File trustStore, String alias, String masterPassword) throws RepositoryException {
        File certFile = null;
        String[] input = new String[]{masterPassword};
        String[] keytoolCmd = null;
        KeytoolExecutor p = null;
        try {
            certFile = new File(keyStore.getParentFile(), alias + ".cer");
            keytoolCmd = new String[]{"-export", "-keystore", keyStore.getAbsolutePath(), "-alias", alias, "-file", certFile.getAbsolutePath()};
            p = new KeytoolExecutor(keytoolCmd, 30L, input);
            p.execute("trustStoreNotCreated", trustStore);
            keytoolCmd = new String[]{"-import", "-noprompt", "-keystore", trustStore.getAbsolutePath(), "-alias", alias, "-file", certFile.getAbsolutePath()};
            p = new KeytoolExecutor(keytoolCmd, 30L, input);
            p.execute("trustStoreNotCreated", trustStore);
        }
        finally {
            boolean isCertFileDeleted;
            if (certFile != null && !(isCertFileDeleted = certFile.delete())) {
                SLogger.getLogger().log(Level.WARNING, "NCLS-SRVRMGMT-00001", certFile.getAbsolutePath());
            }
        }
    }

    protected void enforcePasswordComplexity(char[] pw, String msgId) {
        if (pw == null || pw.length < 6) {
            throw new IllegalArgumentException(STRING_MANAGER.getString(msgId));
        }
    }

    public KeyStore openKeyStore(File source, String storeType, char[] pw) throws KeyStoreException {
        KeyStore keyStore = KeyStore.getInstance(storeType);
        try (FileInputStream keyStoreStream = new FileInputStream(source);){
            keyStore.load(keyStoreStream, pw);
        }
        catch (Exception ex) {
            throw new KeyStoreException(ex);
        }
        return keyStore;
    }

    public void saveKeyStore(KeyStore keyStore, File dest, char[] pw) throws KeyStoreException {
        this.enforcePasswordComplexity(pw, "invalidPassword");
        try (FileOutputStream outStream = new FileOutputStream(dest);){
            keyStore.store(outStream, pw);
            outStream.flush();
        }
        catch (Exception ex) {
            throw new KeyStoreException(ex);
        }
    }

    public void addKeyPair(File keyStore, String storeType, char[] storePw, PrivateKey privKey, Certificate[] certChain, String alias) throws KeyStoreException {
        this.enforcePasswordComplexity(storePw, "invalidPassword");
        KeyStore ks = this.openKeyStore(keyStore, storeType, storePw);
        ks.setKeyEntry(alias, privKey, storePw, certChain);
        this.saveKeyStore(ks, keyStore, storePw);
    }

    public void addKeyPair(File keyStore, String storeType, char[] storePw, PrivateKey privKey, char[] keyPw, Certificate[] certChain, String alias) throws KeyStoreException {
        this.enforcePasswordComplexity(keyPw, "invalidPassword");
        KeyStore ks = this.openKeyStore(keyStore, storeType, storePw);
        ks.setKeyEntry(alias, privKey, keyPw, certChain);
        this.saveKeyStore(ks, keyStore, storePw);
    }

    protected void changeKeyStorePassword(String oldPassword, String newPassword, File keystore) throws RepositoryException {
        if (!oldPassword.equals(newPassword)) {
            String[] keytoolCmd = new String[]{"-storepasswd", "-keystore", keystore.getAbsolutePath()};
            KeytoolExecutor p = new KeytoolExecutor(keytoolCmd, 30L, new String[]{oldPassword, newPassword, newPassword});
            p.execute("keyStorePasswordNotChanged", keystore);
        }
    }

    public void changeKeyStorePassword(File keyStore, String storeType, char[] oldPw, char[] newPw) throws KeyStoreException {
        this.changeKeyStorePassword(keyStore, storeType, oldPw, newPw, true);
    }

    public void changeKeyStorePassword(File keyStore, String storeType, char[] oldPw, char[] newPw, boolean changeKeyPasswords) throws KeyStoreException {
        this.enforcePasswordComplexity(newPw, "invalidPassword");
        KeyStore ks = this.openKeyStore(keyStore, storeType, oldPw);
        if (changeKeyPasswords) {
            Enumeration<String> aliases = ks.aliases();
            try {
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    Key k = ks.getKey(alias, oldPw);
                    if (k == null) continue;
                    Certificate[] certChain = ks.getCertificateChain(alias);
                    ks.setKeyEntry(alias, k, newPw, certChain);
                }
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException ex) {
                throw new KeyStoreException(ex);
            }
        }
        this.saveKeyStore(ks, keyStore, newPw);
    }

    public void changeKeyPassword(File keyStore, String storeType, char[] storePw, String alias, char[] oldKeyPw, char[] newKeyPw) throws KeyStoreException {
        this.enforcePasswordComplexity(newKeyPw, "invalidPassword");
        try {
            KeyStore ks = this.openKeyStore(keyStore, storeType, storePw);
            Key privKey = ks.getKey(alias, storePw);
            Certificate[] certs = ks.getCertificateChain(alias);
            ks.setKeyEntry(alias, privKey, newKeyPw, certs);
            this.saveKeyStore(ks, keyStore, storePw);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException ex) {
            throw new KeyStoreException(ex);
        }
    }

    public PrivateKey readPlainPKCS8PrivateKey(File keyFile) throws IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(this.extractPrivateKeyBytes(Files.lines(keyFile.toPath()))));
    }

    public PrivateKey readPlainPKCS8PrivateKey(InputStream is, String algo) throws InvalidKeySpecException, NoSuchAlgorithmException {
        KeyFactory keyFactory = KeyFactory.getInstance(algo);
        return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(this.extractPrivateKeyBytes(new BufferedReader(new InputStreamReader(is)).lines())));
    }

    byte[] extractPrivateKeyBytes(Stream<String> privateKeyLines) {
        String base64KeyData = privateKeyLines.filter(line -> line.charAt(0) != '-').collect(Collectors.joining());
        return Base64.getDecoder().decode(base64KeyData);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<? extends Certificate> readPemCertificateChain(File pemFile) throws KeyStoreException {
        try (FileInputStream is = new FileInputStream(pemFile);){
            Collection<? extends Certificate> collection = CertificateFactory.getInstance("X.509").generateCertificates(is);
            return collection;
        }
        catch (Exception ex) {
            throw new KeyStoreException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeS1ASAliasPassword(RepositoryConfig config, String storePassword, String oldKeyPassword, String newKeyPassword) throws RepositoryException {
        if (!storePassword.equals(oldKeyPassword) && !oldKeyPassword.equals(newKeyPassword)) {
            PEFileLayout layout = this.getFileLayout(config);
            File keystore = layout.getKeyStore();
            String keyStoreType = System.getProperty("javax.net.ssl.keyStoreType");
            if (keyStoreType == null) {
                keyStoreType = KeyStore.getDefaultType();
            }
            ArrayList<String> aliases = new ArrayList<String>();
            FileInputStream is = null;
            try {
                KeyStore keyStore = KeyStore.getInstance(keyStoreType);
                is = new FileInputStream(keystore);
                keyStore.load(is, storePassword.toCharArray());
                Enumeration<String> all = keyStore.aliases();
                while (all.hasMoreElements()) {
                    aliases.add(all.nextElement());
                }
            }
            catch (Exception e) {
                aliases.add(CERTIFICATE_ALIAS);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ex) {
                        SLogger.getLogger().log(Level.SEVERE, "NCLS-SRVRMGMT-00000", ex);
                    }
                }
            }
            String[] keytoolCmd = new String[]{"-list", "-keystore", keystore.getAbsolutePath(), "-alias", CERTIFICATE_ALIAS};
            KeytoolExecutor p = new KeytoolExecutor(keytoolCmd, 30L, new String[]{storePassword});
            try {
                p.execute("s1asKeyPasswordNotChanged", keystore);
            }
            catch (RepositoryException ex) {
                return;
            }
            for (String alias : aliases) {
                keytoolCmd = new String[]{"-keypasswd", "-keystore", keystore.getAbsolutePath(), "-alias", alias};
                p = new KeytoolExecutor(keytoolCmd, 30L, new String[]{storePassword, oldKeyPassword, newKeyPassword, newKeyPassword});
                p.execute("s1asKeyPasswordNotChanged", keystore);
            }
        }
    }

    protected void changeSSLCertificateDatabasePassword(RepositoryConfig config, String oldPassword, String newPassword) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File keystore = layout.getKeyStore();
        File truststore = layout.getTrustStore();
        if (keystore.exists()) {
            this.changeKeyStorePassword(oldPassword, newPassword, keystore);
            try {
                this.changeS1ASAliasPassword(config, newPassword, oldPassword, newPassword);
            }
            catch (Exception ex) {
                SLogger.getLogger().log(Level.SEVERE, "NCLS-SRVRMGMT-00000", ex);
            }
        }
        if (truststore.exists()) {
            this.changeKeyStorePassword(oldPassword, newPassword, truststore);
        }
    }

    protected void chmod(String args, File file) throws IOException {
        if (OS.isUNIX()) {
            if (args == null || file == null) {
                throw new IOException(STRING_MANAGER.getString("nullArg"));
            }
            if (!file.exists()) {
                throw new IOException(STRING_MANAGER.getString("fileNotFound"));
            }
            String[] argsString = args.split(" +");
            ArrayList<String> cmdList = new ArrayList<String>();
            cmdList.add("/bin/chmod");
            cmdList.addAll(Arrays.asList(argsString));
            cmdList.add(file.getAbsolutePath());
            new ProcessBuilder(cmdList).start();
        }
    }

    public static String getDASCertDN(RepositoryConfig cfg) {
        return KeystoreManager.getCertificateDN(cfg, null);
    }

    public static String getInstanceCertDN(RepositoryConfig cfg) {
        return KeystoreManager.getCertificateDN(cfg, INSTANCE_CN_SUFFIX);
    }

    private static String getCNFromCfg(RepositoryConfig cfg) {
        String option = (String)cfg.get("keytooloptions");
        if (option == null || option.length() == 0) {
            return null;
        }
        String value = KeystoreManager.getCNFromOption(option);
        if (value == null || value.length() == 0) {
            return null;
        }
        return value;
    }

    private static String getValueFromOptionForName(String option, String name, boolean ignoreNameCase) {
        String[] pairs;
        Pattern p = Pattern.compile(":");
        for (String pair : pairs = p.split(option)) {
            boolean found;
            p = Pattern.compile("=");
            String[] nv = p.split(pair);
            String n = nv[0].trim();
            String v = nv[1].trim();
            boolean bl = found = ignoreNameCase ? n.equalsIgnoreCase(name) : n.equals(name);
            if (!found) continue;
            return v;
        }
        return null;
    }

    private static String getCNFromOption(String option) {
        return KeystoreManager.getValueFromOptionForName(option, OID.CN.getName(), true);
    }

    static {
        KEYTOOL_EXE_NAME = OS.isWindows() ? "keytool.exe" : "keytool";
        STRING_MANAGER = StringManager.getManager(KeystoreManager.class);
        String nonFinalKeyTool = KEYTOOL_EXE_NAME;
        String propName = "com.sun.aas.javaRoot";
        String javaroot = (String)new ASenvPropertyReader().getProps().get(propName);
        File k = new File(new File(javaroot, "bin"), KEYTOOL_EXE_NAME);
        if (k.canExecute()) {
            nonFinalKeyTool = SmartFile.sanitize((String)k.getPath());
        } else {
            k = ProcessUtils.getExe((String)KEYTOOL_EXE_NAME);
            if (k != null && k.canExecute()) {
                nonFinalKeyTool = k.getPath();
            }
        }
        KEYTOOL_CMD = nonFinalKeyTool;
    }

    public static class KeytoolExecutor
    extends ProcessExecutor {
        public KeytoolExecutor(String[] args, long timeoutInSeconds) {
            super(args, timeoutInSeconds);
            this.setExecutionRetentionFlag(true);
            this.addKeytoolCommand();
        }

        public KeytoolExecutor(String[] args, long timeoutInSeconds, String[] inputLines) {
            super(args, timeoutInSeconds, inputLines);
            this.setExecutionRetentionFlag(true);
            this.addKeytoolCommand();
        }

        protected String getExceptionMessage() {
            return this.getLatestOutput(this.mOutFile) + " " + this.getFileBuffer(this.mErrFile);
        }

        private void addKeytoolCommand() {
            if (!this.mCmdStrings[0].equals(KEYTOOL_CMD)) {
                String[] newArgs = new String[this.mCmdStrings.length + 1];
                newArgs[0] = KEYTOOL_CMD;
                System.arraycopy(this.mCmdStrings, 0, newArgs, 1, this.mCmdStrings.length);
                this.mCmdStrings = newArgs;
            }
        }

        public void execute(String keystoreErrorMsg, File keystoreName) throws RepositoryException {
            try {
                super.execute();
                if (this.getProcessExitValue() != 0) {
                    throw new RepositoryException(STRING_MANAGER.getString(keystoreErrorMsg, (Object)keystoreName) + this.getLastExecutionError() + " " + this.getLastExecutionOutput());
                }
            }
            catch (ExecException ex) {
                throw new RepositoryException(STRING_MANAGER.getString(keystoreErrorMsg, (Object)keystoreName) + this.getLastExecutionError() + " " + this.getLastExecutionOutput(), ex);
            }
        }
    }
}

