/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.admin.servermgmt.cli;

import com.sun.enterprise.admin.servermgmt.cli.ChangeMasterPasswordCommandDAS;
import com.sun.enterprise.admin.servermgmt.cli.LocalDomainCommand;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.HostAndPort;
import com.sun.enterprise.util.net.NetUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.security.common.FileProtectionUtility;
import org.jvnet.hk2.annotations.Service;

@Service(name="generate-encryption-key")
@PerLookup
public class GenerateEncryptionKey
extends LocalDomainCommand {
    @Param(name="domain_name", primary=true, optional=true)
    private String domainName;
    private static final String DATAGRID_KEY_FILE = "datagrid-key";
    private static final LocalStringsImpl SERVERMGMT_CLI_STRINGS = new LocalStringsImpl(ChangeMasterPasswordCommandDAS.class);
    private static final Random random = new SecureRandom();
    private static final String PBKDF_ALGORITHM = "PBKDF2WithHmacSHA1";
    private static final int ITERATION_COUNT = 65556;
    private static final int KEYSIZE = 256;
    private static final String AES = "AES";
    private static final String AES_ALGORITHM = "AES/CBC/PKCS5Padding";

    @Override
    protected void validate() throws CommandException {
        this.setDomainName(this.domainName);
        super.validate();
        this.checkDomainIsNotRunning();
    }

    protected int executeCommand() throws CommandException {
        char[] masterPasswordChars = this.verifyMasterPassword();
        File datagridKeyFile = new File(this.getServerDirs().getConfigDir(), DATAGRID_KEY_FILE);
        if (!datagridKeyFile.exists()) {
            this.createDatagridEncryptionKeyFile(datagridKeyFile);
        }
        byte[] encodedKey = this.generateAndEncryptKey(masterPasswordChars);
        try {
            Files.write(datagridKeyFile.toPath(), encodedKey, new OpenOption[0]);
        }
        catch (IOException ioe) {
            throw new CommandException("Error writing encoded key to file", (Throwable)ioe);
        }
        return 0;
    }

    private void checkDomainIsNotRunning() throws CommandException {
        HostAndPort adminAddress = this.getAdminAddress();
        if (NetUtils.isRunning((String)adminAddress.getHost(), (int)adminAddress.getPort())) {
            throw new CommandException(SERVERMGMT_CLI_STRINGS.get("domain.is.running", new Object[]{this.getDomainName(), this.getDomainRootDir()}));
        }
    }

    private char[] verifyMasterPassword() throws CommandException {
        String masterpassword = super.readFromMasterPasswordFile();
        if (masterpassword == null && (masterpassword = (String)this.passwords.get("AS_ADMIN_MASTERPASSWORD")) == null) {
            char[] masterpasswordChars = super.readPassword(SERVERMGMT_CLI_STRINGS.get("current.mp"));
            String string = masterpassword = masterpasswordChars != null ? new String(masterpasswordChars) : null;
        }
        if (masterpassword == null) {
            throw new CommandException(SERVERMGMT_CLI_STRINGS.get("no.console"));
        }
        if (!super.verifyMasterPassword(masterpassword)) {
            throw new CommandException(SERVERMGMT_CLI_STRINGS.get("incorrect.mp"));
        }
        return masterpassword.toCharArray();
    }

    private void createDatagridEncryptionKeyFile(File datagridKeyFile) throws CommandException {
        try {
            Files.createFile(datagridKeyFile.toPath(), new FileAttribute[0]);
            FileProtectionUtility.chmod0600((File)datagridKeyFile);
        }
        catch (IOException ioe) {
            throw new CommandException(ioe.getMessage(), (Throwable)ioe);
        }
    }

    private byte[] generateAndEncryptKey(char[] masterpasswordChars) throws CommandException {
        byte[] saltBytes = new byte[20];
        random.nextBytes(saltBytes);
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance(PBKDF_ALGORITHM);
            PBEKeySpec spec = new PBEKeySpec(masterpasswordChars, saltBytes, 65556, 256);
            SecretKeySpec secret = new SecretKeySpec(factory.generateSecret(spec).getEncoded(), AES);
            Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
            cipher.init(1, secret);
            AlgorithmParameters params = cipher.getParameters();
            byte[] ivBytes = params.getParameterSpec(IvParameterSpec.class).getIV();
            byte[] keyBytes = new byte[32];
            random.nextBytes(keyBytes);
            byte[] encryptedTextBytes = cipher.doFinal(keyBytes);
            byte[] buffer = new byte[saltBytes.length + ivBytes.length + encryptedTextBytes.length];
            System.arraycopy(saltBytes, 0, buffer, 0, saltBytes.length);
            System.arraycopy(ivBytes, 0, buffer, saltBytes.length, ivBytes.length);
            System.arraycopy(encryptedTextBytes, 0, buffer, saltBytes.length + ivBytes.length, encryptedTextBytes.length);
            return buffer;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | InvalidParameterSpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException exception) {
            throw new CommandException(exception.getMessage(), (Throwable)exception);
        }
    }
}

