/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid;

import fish.payara.security.openid.api.AccessToken;
import fish.payara.security.openid.api.IdentityToken;
import fish.payara.security.openid.domain.AccessTokenImpl;
import fish.payara.security.openid.domain.IdentityTokenImpl;
import fish.payara.security.openid.domain.OpenIdConfiguration;
import java.util.Objects;
import javax.json.JsonObject;
import javax.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import javax.security.enterprise.credential.Credential;

public class OpenIdCredential
implements Credential {
    private final HttpMessageContext httpContext;
    private final OpenIdConfiguration configuration;
    private final IdentityToken identityToken;
    private AccessToken accessToken;

    public OpenIdCredential(JsonObject tokensObject, HttpMessageContext httpContext, OpenIdConfiguration configuration) {
        this.httpContext = httpContext;
        this.configuration = configuration;
        this.identityToken = new IdentityTokenImpl(configuration, tokensObject.getString("id_token"));
        String accessTokenString = tokensObject.getString("access_token", null);
        Long expiresIn = null;
        if (Objects.nonNull(tokensObject.getJsonNumber("expires_in"))) {
            expiresIn = tokensObject.getJsonNumber("expires_in").longValue();
        }
        String tokenType = tokensObject.getString("token_type", null);
        String scopeString = tokensObject.getString("scope", null);
        if (Objects.nonNull(accessTokenString)) {
            this.accessToken = new AccessTokenImpl(configuration, tokenType, accessTokenString, expiresIn, scopeString);
        }
    }

    public IdentityToken getIdentityToken() {
        return this.identityToken;
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public HttpMessageContext getHttpContext() {
        return this.httpContext;
    }

    public OpenIdConfiguration getConfiguration() {
        return this.configuration;
    }
}

