/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid;

import com.nimbusds.jose.Algorithm;
import fish.payara.security.openid.OpenIdCredential;
import fish.payara.security.openid.controller.TokenController;
import fish.payara.security.openid.controller.UserInfoController;
import fish.payara.security.openid.domain.AccessTokenImpl;
import fish.payara.security.openid.domain.IdentityTokenImpl;
import fish.payara.security.openid.domain.OpenIdConfiguration;
import fish.payara.security.openid.domain.OpenIdContextImpl;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import javax.security.enterprise.identitystore.CredentialValidationResult;
import javax.security.enterprise.identitystore.IdentityStore;
import net.minidev.json.JSONArray;

@Typed(value={OpenIdIdentityStore.class})
public class OpenIdIdentityStore
implements IdentityStore {
    @Inject
    private OpenIdContextImpl context;
    @Inject
    private TokenController tokenController;
    @Inject
    private UserInfoController userInfoController;

    public CredentialValidationResult validate(OpenIdCredential credential) {
        HttpMessageContext httpContext = credential.getHttpContext();
        OpenIdConfiguration configuration = credential.getConfiguration();
        IdentityTokenImpl idToken = (IdentityTokenImpl)credential.getIdentityToken();
        Algorithm idTokenAlgorithm = idToken.getTokenJWT().getHeader().getAlgorithm();
        Map<String, Object> idTokenClaims = Objects.isNull(this.context.getIdentityToken()) ? this.tokenController.validateIdToken(idToken, httpContext, configuration) : this.tokenController.validateRefreshedIdToken(this.context.getIdentityToken(), idToken, httpContext, configuration);
        if (idToken.isEncrypted()) {
            idToken.setClaims(idTokenClaims);
        }
        this.context.setIdentityToken(idToken);
        AccessTokenImpl accessToken = (AccessTokenImpl)credential.getAccessToken();
        if (Objects.nonNull(accessToken)) {
            Map<String, Object> accesTokenClaims = this.tokenController.validateAccessToken(accessToken, idTokenAlgorithm, this.context.getIdentityToken().getClaims(), configuration);
            if (accessToken.isEncrypted()) {
                accessToken.setClaims(accesTokenClaims);
            }
            this.context.setAccessToken(accessToken);
            JsonObject userInfo = this.userInfoController.getUserInfo(configuration, accessToken);
            this.context.setClaims(userInfo);
        }
        this.context.setCallerName(this.getCallerName(configuration));
        this.context.setCallerGroups(this.getCallerGroups(configuration));
        return new CredentialValidationResult(this.context.getCallerName(), this.context.getCallerGroups());
    }

    private String getCallerName(OpenIdConfiguration configuration) {
        String callerNameClaim = configuration.getClaimsConfiguration().getCallerNameClaim();
        String callerName = this.context.getClaimsJson().getString(callerNameClaim, null);
        if (callerName == null) {
            callerName = (String)this.context.getIdentityToken().getClaim(callerNameClaim);
        }
        if (callerName == null) {
            callerName = (String)this.context.getAccessToken().getClaim(callerNameClaim);
        }
        if (callerName == null) {
            callerName = this.context.getSubject();
        }
        return callerName;
    }

    private Set<String> getCallerGroups(OpenIdConfiguration configuration) {
        Set<String> groups = new HashSet<String>();
        String callerGroupsClaim = configuration.getClaimsConfiguration().getCallerGroupsClaim();
        JsonArray groupsUserinfoClaim = this.context.getClaimsJson().getJsonArray(callerGroupsClaim);
        JSONArray groupsIdentityClaim = (JSONArray)this.context.getIdentityToken().getClaim(callerGroupsClaim);
        JSONArray groupsAccessClaim = (JSONArray)this.context.getAccessToken().getClaim(callerGroupsClaim);
        if (Objects.nonNull(groupsUserinfoClaim)) {
            for (int i = 0; i < groupsUserinfoClaim.size(); ++i) {
                JsonValue value = (JsonValue)groupsUserinfoClaim.get(i);
                if (value.getValueType() != JsonValue.ValueType.STRING) continue;
                groups.add(groupsUserinfoClaim.getString(i));
            }
        } else if (Objects.nonNull(groupsIdentityClaim)) {
            groups = groupsIdentityClaim.stream().map(Object::toString).collect(Collectors.toSet());
        } else if (Objects.nonNull(groupsAccessClaim)) {
            groups = groupsAccessClaim.stream().map(Object::toString).collect(Collectors.toSet());
        }
        return groups;
    }
}

