/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid;

import java.util.Optional;
import java.util.function.Predicate;
import javax.el.ELProcessor;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import org.eclipse.microprofile.config.Config;
import org.glassfish.config.support.TranslatedConfigView;

public final class OpenIdUtil {
    public static final String DEFAULT_JWT_SIGNED_ALGORITHM = "RS256";
    public static final String DEFAULT_HASH_ALGORITHM = "SHA-256";

    private OpenIdUtil() {
    }

    public static <T> T getConfiguredValue(Class<T> type, T value, Config provider, String mpConfigKey) {
        Object result = value;
        Optional configResult = provider.getOptionalValue(mpConfigKey, type);
        if (configResult.isPresent()) {
            return configResult.get();
        }
        if (type == String.class) {
            result = TranslatedConfigView.expandValue((String)((String)result));
        }
        if (type == String.class && OpenIdUtil.isELExpression((String)value)) {
            ELProcessor elProcessor = new ELProcessor();
            BeanManager beanManager = CDI.current().getBeanManager();
            elProcessor.getELManager().addELResolver(beanManager.getELResolver());
            result = elProcessor.getValue(OpenIdUtil.toRawExpression((String)result), type);
        }
        return result;
    }

    public static boolean isELExpression(String expression) {
        return !expression.isEmpty() && OpenIdUtil.isDeferredExpression(expression);
    }

    public static boolean isDeferredExpression(String expression) {
        return expression.startsWith("#{") && expression.endsWith("}");
    }

    public static String toRawExpression(String expression) {
        return expression.substring(2, expression.length() - 1);
    }

    public static <T> Predicate<T> not(Predicate<T> t) {
        return t.negate();
    }
}

