/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid.azure;

import fish.payara.security.annotations.AzureAuthenticationDefinition;
import fish.payara.security.annotations.ClaimsDefinition;
import fish.payara.security.annotations.LogoutDefinition;
import fish.payara.security.annotations.OpenIdAuthenticationDefinition;
import fish.payara.security.annotations.OpenIdProviderMetadata;
import fish.payara.security.openid.OpenIdExtension;
import fish.payara.security.openid.OpenIdIdentityStore;
import fish.payara.security.openid.OpenIdUtil;
import fish.payara.security.openid.api.DisplayType;
import fish.payara.security.openid.api.PromptType;
import fish.payara.security.openid.azure.AzureOpenIdAuthenticationMechanism;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.ProcessBean;
import javax.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import javax.security.enterprise.identitystore.IdentityStore;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.glassfish.common.util.StringHelper;

public class AzureOpenIdExtension
extends OpenIdExtension {
    private final List<AzureAuthenticationDefinition> definitions = new ArrayList<AzureAuthenticationDefinition>();

    @Override
    protected void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager manager) {
        this.addAnnotatedType(AzureOpenIdAuthenticationMechanism.class, manager, beforeBeanDiscovery);
        super.beforeBeanDiscovery(beforeBeanDiscovery, manager);
    }

    @Override
    protected <T> void findOpenIdDefinitionAnnotation(@Observes ProcessBean<T> bean, BeanManager beanManager) {
        AzureAuthenticationDefinition definition = (AzureAuthenticationDefinition)bean.getAnnotated().getAnnotation(AzureAuthenticationDefinition.class);
        if (Objects.nonNull(definition) && !this.definitions.contains(definition)) {
            this.definitions.add(definition);
            this.validateExtraParametersFormat(AzureOpenIdExtension.toOpenIdAuthDefinition(definition));
        }
    }

    @Override
    protected void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBean, BeanManager beanManager) {
        if (!this.definitions.isEmpty() && beanManager.getBeans(IdentityStore.class, new Annotation[0]).isEmpty()) {
            afterBean.addBean().scope(ApplicationScoped.class).beanClass(IdentityStore.class).types(new Type[]{IdentityStore.class, Object.class}).createWith(obj -> (OpenIdIdentityStore)CDI.current().select(OpenIdIdentityStore.class, new Annotation[0]).get());
        }
        for (AzureAuthenticationDefinition definition : this.definitions) {
            afterBean.addBean().scope(ApplicationScoped.class).beanClass(HttpAuthenticationMechanism.class).types(new Type[]{HttpAuthenticationMechanism.class, Object.class}).createWith(obj -> ((AzureOpenIdAuthenticationMechanism)CDI.current().select(AzureOpenIdAuthenticationMechanism.class, new Annotation[0]).get()).setConfiguration(definition));
        }
        this.definitions.clear();
    }

    static OpenIdAuthenticationDefinition toOpenIdAuthDefinition(final AzureAuthenticationDefinition azureDefinition) {
        return new OpenIdAuthenticationDefinition(){

            public String providerURI() {
                Config provider = ConfigProvider.getConfig();
                String tenantId = OpenIdUtil.getConfiguredValue(String.class, azureDefinition.tenantId(), provider, "payara.security.openid.azure.tenantId");
                if (StringHelper.isEmpty(tenantId)) {
                    throw new IllegalStateException("tenantId must not be null");
                }
                String providerURI = OpenIdUtil.getConfiguredValue(String.class, azureDefinition.providerURI(), provider, "payara.security.openid.providerURI");
                return providerURI.replace("{tenantid}", tenantId);
            }

            public OpenIdProviderMetadata providerMetadata() {
                return azureDefinition.providerMetadata();
            }

            public ClaimsDefinition claimsDefinition() {
                return azureDefinition.claimsDefinition();
            }

            public LogoutDefinition logout() {
                return azureDefinition.logout();
            }

            public String clientId() {
                return azureDefinition.clientId();
            }

            public String clientSecret() {
                return azureDefinition.clientSecret();
            }

            public String redirectURI() {
                return azureDefinition.redirectURI();
            }

            public String[] scope() {
                return azureDefinition.scope();
            }

            public String responseType() {
                return azureDefinition.responseType();
            }

            public String responseMode() {
                return azureDefinition.responseMode();
            }

            public PromptType[] prompt() {
                return azureDefinition.prompt();
            }

            public DisplayType display() {
                return azureDefinition.display();
            }

            public boolean useNonce() {
                return azureDefinition.useNonce();
            }

            public boolean useSession() {
                return azureDefinition.useSession();
            }

            public String[] extraParameters() {
                return azureDefinition.extraParameters();
            }

            public Class<? extends Annotation> annotationType() {
                return azureDefinition.annotationType();
            }

            public int jwksConnectTimeout() {
                return azureDefinition.jwksConnectTimeout();
            }

            public int jwksReadTimeout() {
                return azureDefinition.jwksReadTimeout();
            }

            public boolean tokenAutoRefresh() {
                return azureDefinition.tokenAutoRefresh();
            }

            public int tokenMinValidity() {
                return azureDefinition.tokenMinValidity();
            }
        };
    }
}

