/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid.controller;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.jwk.source.ImmutableSecret;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.jwk.source.RemoteJWKSet;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.JWEDecryptionKeySelector;
import com.nimbusds.jose.proc.JWEKeySelector;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.util.DefaultResourceRetriever;
import com.nimbusds.jose.util.ResourceRetriever;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import fish.payara.security.openid.api.IdentityToken;
import fish.payara.security.openid.api.RefreshToken;
import fish.payara.security.openid.controller.AccessTokenClaimsSetVerifier;
import fish.payara.security.openid.controller.IdTokenClaimsSetVerifier;
import fish.payara.security.openid.controller.NonceController;
import fish.payara.security.openid.controller.RefreshedIdTokenClaimsSetVerifier;
import fish.payara.security.openid.domain.AccessTokenImpl;
import fish.payara.security.openid.domain.IdentityTokenImpl;
import fish.payara.security.openid.domain.OpenIdConfiguration;
import fish.payara.security.openid.domain.OpenIdNonce;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;

@ApplicationScoped
public class TokenController {
    @Inject
    private NonceController nonceController;

    public Response getTokens(OpenIdConfiguration configuration, HttpServletRequest request) {
        String authorizationCode = request.getParameter("code");
        Form form = new Form().param("client_id", configuration.getClientId()).param("client_secret", new String(configuration.getClientSecret())).param("grant_type", "authorization_code").param("code", authorizationCode).param("redirect_uri", configuration.buildRedirectURI(request));
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(configuration.getProviderMetadata().getTokenEndpoint());
        return target.request().accept(new String[]{"application/json"}).post(Entity.form((Form)form));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> validateIdToken(IdentityTokenImpl idToken, HttpMessageContext httpContext, OpenIdConfiguration configuration) {
        JWTClaimsSet claimsSet;
        HttpServletRequest request = httpContext.getRequest();
        HttpServletResponse response = httpContext.getResponse();
        String expectedNonceHash = null;
        if (configuration.isUseNonce()) {
            OpenIdNonce expectedNonce = this.nonceController.get(configuration, request, response);
            expectedNonceHash = this.nonceController.getNonceHash(expectedNonce);
        }
        try {
            IdTokenClaimsSetVerifier jwtVerifier = new IdTokenClaimsSetVerifier(expectedNonceHash, configuration);
            claimsSet = this.validateBearerToken(idToken.getTokenJWT(), jwtVerifier, configuration);
        }
        finally {
            this.nonceController.remove(configuration, request, response);
        }
        return claimsSet.getClaims();
    }

    public Map<String, Object> validateRefreshedIdToken(IdentityToken previousIdToken, IdentityTokenImpl newIdToken, HttpMessageContext httpContext, OpenIdConfiguration configuration) {
        RefreshedIdTokenClaimsSetVerifier jwtVerifier = new RefreshedIdTokenClaimsSetVerifier(previousIdToken, configuration);
        JWTClaimsSet claimsSet = this.validateBearerToken(newIdToken.getTokenJWT(), jwtVerifier, configuration);
        return claimsSet.getClaims();
    }

    public Map<String, Object> validateAccessToken(AccessTokenImpl accessToken, Algorithm idTokenAlgorithm, Map<String, Object> idTokenClaims, OpenIdConfiguration configuration) {
        Map<String, Object> claims = Collections.emptyMap();
        AccessTokenClaimsSetVerifier jwtVerifier = new AccessTokenClaimsSetVerifier(accessToken, idTokenAlgorithm, idTokenClaims, configuration);
        jwtVerifier.validateAccessToken();
        return claims;
    }

    public Response refreshTokens(OpenIdConfiguration configuration, RefreshToken refreshToken) {
        Form form = new Form().param("client_id", configuration.getClientId()).param("client_secret", new String(configuration.getClientSecret())).param("grant_type", "refresh_token").param("refresh_token", refreshToken.getToken());
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(configuration.getProviderMetadata().getTokenEndpoint());
        return target.request().accept(new String[]{"application/json"}).post(Entity.form((Form)form));
    }

    private JWTClaimsSet validateBearerToken(JWT token, JWTClaimsSetVerifier jwtVerifier, OpenIdConfiguration configuration) {
        JWTClaimsSet claimsSet;
        block6: {
            try {
                if (token instanceof PlainJWT) {
                    PlainJWT plainToken = (PlainJWT)token;
                    claimsSet = plainToken.getJWTClaimsSet();
                    jwtVerifier.verify(claimsSet, null);
                    break block6;
                }
                if (token instanceof SignedJWT) {
                    SignedJWT signedToken = (SignedJWT)token;
                    JWSHeader header = signedToken.getHeader();
                    String alg = header.getAlgorithm().getName();
                    if (Objects.isNull(alg)) {
                        alg = "RS256";
                    }
                    DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
                    jwtProcessor.setJWSKeySelector(this.getJWSKeySelector(configuration, alg));
                    jwtProcessor.setJWTClaimsSetVerifier(jwtVerifier);
                    claimsSet = jwtProcessor.process(signedToken, null);
                    break block6;
                }
                if (token instanceof EncryptedJWT) {
                    EncryptedJWT encryptedToken = (EncryptedJWT)token;
                    JWEHeader header = encryptedToken.getHeader();
                    String alg = header.getAlgorithm().getName();
                    DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
                    jwtProcessor.setJWSKeySelector(this.getJWSKeySelector(configuration, alg));
                    jwtProcessor.setJWEKeySelector(this.getJWEKeySelector(configuration));
                    jwtProcessor.setJWTClaimsSetVerifier(jwtVerifier);
                    claimsSet = jwtProcessor.process(encryptedToken, null);
                    break block6;
                }
                throw new IllegalStateException("Unexpected JWT type : " + token.getClass());
            }
            catch (JOSEException | BadJOSEException | ParseException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return claimsSet;
    }

    private JWSKeySelector getJWSKeySelector(OpenIdConfiguration configuration, String alg) {
        RemoteJWKSet jwkSource;
        JWSAlgorithm jWSAlgorithm = new JWSAlgorithm(alg);
        if (Algorithm.NONE.equals((Object)jWSAlgorithm)) {
            throw new IllegalStateException("Unsupported JWS algorithm : " + jWSAlgorithm);
        }
        if (JWSAlgorithm.Family.RSA.contains((Object)jWSAlgorithm) || JWSAlgorithm.Family.EC.contains((Object)jWSAlgorithm)) {
            DefaultResourceRetriever jwkSetRetriever = new DefaultResourceRetriever(configuration.getJwksConnectTimeout(), configuration.getJwksReadTimeout(), 51200);
            jwkSource = new RemoteJWKSet(configuration.getProviderMetadata().getJwksURL(), (ResourceRetriever)jwkSetRetriever);
        } else if (JWSAlgorithm.Family.HMAC_SHA.contains((Object)jWSAlgorithm)) {
            byte[] clientSecret = new String(configuration.getClientSecret()).getBytes(StandardCharsets.UTF_8);
            if (Objects.isNull(clientSecret)) {
                throw new IllegalStateException("Missing client secret");
            }
            jwkSource = new ImmutableSecret(clientSecret);
        } else {
            throw new IllegalStateException("Unsupported JWS algorithm : " + jWSAlgorithm);
        }
        return new JWSVerificationKeySelector(jWSAlgorithm, (JWKSource)jwkSource);
    }

    private JWEKeySelector getJWEKeySelector(OpenIdConfiguration configuration) {
        JWEAlgorithm jwsAlg = configuration.getEncryptionMetadata().getEncryptionAlgorithm();
        EncryptionMethod jweEnc = configuration.getEncryptionMetadata().getEncryptionMethod();
        JWKSource jwkSource = configuration.getEncryptionMetadata().getPrivateKeySource();
        if (Objects.isNull(jwsAlg)) {
            throw new IllegalStateException("Missing JWE encryption algorithm ");
        }
        if (!configuration.getProviderMetadata().getIdTokenEncryptionAlgorithmsSupported().contains(jwsAlg.getName())) {
            throw new IllegalStateException("Unsupported ID tokens algorithm :" + jwsAlg.getName());
        }
        if (Objects.isNull(jweEnc)) {
            throw new IllegalStateException("Missing JWE encryption method");
        }
        if (!configuration.getProviderMetadata().getIdTokenEncryptionMethodsSupported().contains(jweEnc.getName())) {
            throw new IllegalStateException("Unsupported ID tokens encryption method :" + jweEnc.getName());
        }
        JWEDecryptionKeySelector jweKeySelector = new JWEDecryptionKeySelector(jwsAlg, jweEnc, jwkSource);
        return jweKeySelector;
    }
}

