/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid.domain;

import java.net.URL;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

public class OpenIdProviderMetadata {
    private JsonObject document;
    private final String issuerURI;
    private String authorizationEndpoint;
    private String tokenEndpoint;
    private String userinfoEndpoint;
    private String endSessionEndpoint;
    private URL jwksURL;
    private final Set<String> scopesSupported;
    private final Set<String> claimsSupported;
    private final Set<String> responseTypeSupported;
    private final Set<String> idTokenSigningAlgorithmsSupported;
    private final Set<String> idTokenEncryptionAlgorithmsSupported;
    private final Set<String> idTokenEncryptionMethodsSupported;
    private final Set<String> subjectTypesSupported;

    public OpenIdProviderMetadata(JsonObject document) {
        this.document = document;
        this.issuerURI = document.getString("issuer");
        this.scopesSupported = this.getValues("scopes_supported");
        this.claimsSupported = this.getValues("claims_supported");
        this.responseTypeSupported = this.getValues("response_types_supported");
        this.idTokenSigningAlgorithmsSupported = this.getValues("id_token_signing_alg_values_supported");
        this.idTokenEncryptionAlgorithmsSupported = this.getValues("id_token_encryption_alg_values_supported");
        this.idTokenEncryptionMethodsSupported = this.getValues("id_token_encryption_enc_values_supported");
        this.subjectTypesSupported = this.getValues("subject_types_supported");
    }

    public String getIssuerURI() {
        return this.issuerURI;
    }

    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public OpenIdProviderMetadata setAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
        return this;
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public OpenIdProviderMetadata setTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
        return this;
    }

    public String getUserinfoEndpoint() {
        return this.userinfoEndpoint;
    }

    public OpenIdProviderMetadata setUserinfoEndpoint(String userinfoEndpoint) {
        this.userinfoEndpoint = userinfoEndpoint;
        return this;
    }

    public String getEndSessionEndpoint() {
        return this.endSessionEndpoint;
    }

    public OpenIdProviderMetadata setEndSessionEndpoint(String endSessionEndpoint) {
        this.endSessionEndpoint = endSessionEndpoint;
        return this;
    }

    public URL getJwksURL() {
        return this.jwksURL;
    }

    public OpenIdProviderMetadata setJwksURL(URL jwksURL) {
        this.jwksURL = jwksURL;
        return this;
    }

    public JsonObject getDocument() {
        return this.document;
    }

    public OpenIdProviderMetadata setDocument(JsonObject document) {
        this.document = document;
        return this;
    }

    public Set<String> getScopesSupported() {
        return this.scopesSupported;
    }

    public Set<String> getClaimsSupported() {
        return this.claimsSupported;
    }

    public Set<String> getResponseTypeSupported() {
        return this.responseTypeSupported;
    }

    public Set<String> getSubjectTypesSupported() {
        return this.subjectTypesSupported;
    }

    public Set<String> getIdTokenSigningAlgorithmsSupported() {
        return this.idTokenSigningAlgorithmsSupported;
    }

    public Set<String> getIdTokenEncryptionAlgorithmsSupported() {
        return this.idTokenEncryptionAlgorithmsSupported;
    }

    public Set<String> getIdTokenEncryptionMethodsSupported() {
        return this.idTokenEncryptionMethodsSupported;
    }

    private Set<String> getValues(String key) {
        JsonArray jsonArray = this.document.getJsonArray(key);
        if (Objects.isNull(jsonArray)) {
            return Collections.emptySet();
        }
        return jsonArray.stream().filter(element -> element.getValueType() == JsonValue.ValueType.STRING).map(element -> (JsonString)element).map(JsonString::getString).collect(Collectors.toSet());
    }

    public String toString() {
        return OpenIdProviderMetadata.class.getSimpleName() + "{issuerURI=" + this.issuerURI + ", authorizationEndpoint=" + this.authorizationEndpoint + ", tokenEndpoint=" + this.tokenEndpoint + ", userinfoEndpoint=" + this.userinfoEndpoint + ", jwksURI=" + this.jwksURL + '}';
    }
}

