/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid.domain;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.source.ImmutableJWKSet;
import com.nimbusds.jose.jwk.source.JWKSource;
import java.text.ParseException;
import org.glassfish.common.util.StringHelper;

public class OpenIdTokenEncryptionMetadata {
    private JWEAlgorithm encryptionAlgorithm;
    private EncryptionMethod encryptionMethod;
    private JWKSource privateKeySource;

    public JWEAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public OpenIdTokenEncryptionMetadata setEncryptionAlgorithm(JWEAlgorithm encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        return this;
    }

    public OpenIdTokenEncryptionMetadata setEncryptionAlgorithm(String encryptionAlgorithm) {
        if (!StringHelper.isEmpty(encryptionAlgorithm)) {
            this.encryptionAlgorithm = JWEAlgorithm.parse((String)encryptionAlgorithm);
        }
        return this;
    }

    public EncryptionMethod getEncryptionMethod() {
        return this.encryptionMethod;
    }

    public OpenIdTokenEncryptionMetadata setEncryptionMethod(EncryptionMethod encryptionMethod) {
        this.encryptionMethod = encryptionMethod;
        return this;
    }

    public OpenIdTokenEncryptionMetadata setEncryptionMethod(String encryptionMethod) {
        if (!StringHelper.isEmpty(encryptionMethod)) {
            this.encryptionMethod = EncryptionMethod.parse((String)encryptionMethod);
        }
        return this;
    }

    public JWKSource getPrivateKeySource() {
        return this.privateKeySource;
    }

    public OpenIdTokenEncryptionMetadata setPrivateKeySource(JWKSource privateKeySource) {
        this.privateKeySource = privateKeySource;
        return this;
    }

    public OpenIdTokenEncryptionMetadata setPrivateKeySource(String jwks) {
        if (!StringHelper.isEmpty(jwks)) {
            try {
                this.privateKeySource = new ImmutableJWKSet(JWKSet.parse((String)jwks));
            }
            catch (ParseException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return this;
    }

    public String toString() {
        return OpenIdTokenEncryptionMetadata.class.getSimpleName() + "{encryptionAlgorithm=" + this.encryptionAlgorithm + ", encryptionMethod=" + this.encryptionMethod + '}';
    }
}

