/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.security.openid.google;

import fish.payara.security.annotations.ClaimsDefinition;
import fish.payara.security.annotations.GoogleAuthenticationDefinition;
import fish.payara.security.annotations.LogoutDefinition;
import fish.payara.security.annotations.OpenIdAuthenticationDefinition;
import fish.payara.security.annotations.OpenIdProviderMetadata;
import fish.payara.security.openid.OpenIdExtension;
import fish.payara.security.openid.OpenIdIdentityStore;
import fish.payara.security.openid.api.DisplayType;
import fish.payara.security.openid.api.PromptType;
import fish.payara.security.openid.google.GoogleOpenIdAuthenticationMechanism;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.ProcessBean;
import javax.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import javax.security.enterprise.identitystore.IdentityStore;

public class GoogleOpenIdExtension
extends OpenIdExtension {
    private final List<GoogleAuthenticationDefinition> definitions = new ArrayList<GoogleAuthenticationDefinition>();

    @Override
    protected void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager manager) {
        this.addAnnotatedType(GoogleOpenIdAuthenticationMechanism.class, manager, beforeBeanDiscovery);
        super.beforeBeanDiscovery(beforeBeanDiscovery, manager);
    }

    @Override
    protected <T> void findOpenIdDefinitionAnnotation(@Observes ProcessBean<T> bean, BeanManager beanManager) {
        GoogleAuthenticationDefinition definition = (GoogleAuthenticationDefinition)bean.getAnnotated().getAnnotation(GoogleAuthenticationDefinition.class);
        if (Objects.nonNull(definition) && !this.definitions.contains(definition)) {
            this.definitions.add(definition);
            this.validateExtraParametersFormat(GoogleOpenIdExtension.toOpenIdAuthDefinition(definition));
        }
    }

    @Override
    protected void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBean, BeanManager beanManager) {
        if (!this.definitions.isEmpty() && beanManager.getBeans(IdentityStore.class, new Annotation[0]).isEmpty()) {
            afterBean.addBean().scope(ApplicationScoped.class).beanClass(IdentityStore.class).types(new Type[]{IdentityStore.class, Object.class}).createWith(obj -> (OpenIdIdentityStore)CDI.current().select(OpenIdIdentityStore.class, new Annotation[0]).get());
        }
        for (GoogleAuthenticationDefinition definition : this.definitions) {
            afterBean.addBean().scope(ApplicationScoped.class).beanClass(HttpAuthenticationMechanism.class).types(new Type[]{HttpAuthenticationMechanism.class, Object.class}).createWith(obj -> ((GoogleOpenIdAuthenticationMechanism)CDI.current().select(GoogleOpenIdAuthenticationMechanism.class, new Annotation[0]).get()).setConfiguration(definition));
        }
        this.definitions.clear();
    }

    static OpenIdAuthenticationDefinition toOpenIdAuthDefinition(final GoogleAuthenticationDefinition googleDefinition) {
        return new OpenIdAuthenticationDefinition(){

            public String providerURI() {
                return googleDefinition.providerURI();
            }

            public OpenIdProviderMetadata providerMetadata() {
                return googleDefinition.providerMetadata();
            }

            public ClaimsDefinition claimsDefinition() {
                return googleDefinition.claimsDefinition();
            }

            public LogoutDefinition logout() {
                return googleDefinition.logout();
            }

            public String clientId() {
                return googleDefinition.clientId();
            }

            public String clientSecret() {
                return googleDefinition.clientSecret();
            }

            public String redirectURI() {
                return googleDefinition.redirectURI();
            }

            public String[] scope() {
                return googleDefinition.scope();
            }

            public String responseType() {
                return googleDefinition.responseType();
            }

            public String responseMode() {
                return googleDefinition.responseMode();
            }

            public PromptType[] prompt() {
                return googleDefinition.prompt();
            }

            public DisplayType display() {
                return googleDefinition.display();
            }

            public boolean useNonce() {
                return googleDefinition.useNonce();
            }

            public boolean useSession() {
                return googleDefinition.useSession();
            }

            public String[] extraParameters() {
                return googleDefinition.extraParameters();
            }

            public Class<? extends Annotation> annotationType() {
                return googleDefinition.annotationType();
            }

            public int jwksConnectTimeout() {
                return googleDefinition.jwksConnectTimeout();
            }

            public int jwksReadTimeout() {
                return googleDefinition.jwksReadTimeout();
            }

            public boolean tokenAutoRefresh() {
                return googleDefinition.tokenAutoRefresh();
            }

            public int tokenMinValidity() {
                return googleDefinition.tokenMinValidity();
            }
        };
    }
}

