/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.grizzly.config.dom.FileCache;
import org.glassfish.grizzly.config.dom.Http;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.Protocols;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.glassfish.web.admin.LogFacade;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-http")
@PerLookup
@I18n(value="create.http")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=Protocol.class, opType=RestEndpoint.OpType.POST, path="create-http", description="Create", params={@RestParam(name="id", value="$parent")})})
public class CreateHttp
implements AdminCommand {
    private static final ResourceBundle rb = LogFacade.getLogger().getResourceBundle();
    @Param(name="protocolname", primary=true)
    String protocolName;
    @Param(name="request-timeout-seconds", optional=true, alias="requestTimeoutSeconds")
    String requestTimeoutSeconds;
    @Param(name="timeout-seconds", defaultValue="30", optional=true, alias="timeoutSeconds")
    String timeoutSeconds;
    @Param(name="max-connection", defaultValue="256", optional=true, alias="maxConnections")
    String maxConnections;
    @Param(name="default-virtual-server", alias="defaultVirtualServer")
    String defaultVirtualServer;
    @Param(name="dns-lookup-enabled", defaultValue="false", optional=true, alias="dnsLookupEnabled")
    Boolean dnsLookupEnabled = false;
    @Param(name="servername", optional=true, alias="serverName")
    String serverName;
    @Param(name="xpowered", optional=true, defaultValue="true", alias="xpoweredBy")
    Boolean xPoweredBy = false;
    @Param(name="serverHeader", optional=true, defaultValue="true", alias="serverHeader")
    Boolean serverHeader = false;
    @Param(name="xframe", optional=true, defaultValue="true", alias="xframeOptions")
    Boolean xFrameOptions = false;
    @Param(name="http2Enabled", alias="http2enabled", optional=true, defaultValue="true")
    Boolean http2Enabled;
    @Param(name="http2MaxConcurrentStreams", alias="http2maxconcurrentstreams", optional=true)
    Integer http2MaxConcurrentStreams;
    @Param(name="http2InitialWindowSizeInBytes", alias="http2initialwindowsizeinbytes", optional=true)
    Integer http2InitialWindowSizeInBytes;
    @Param(name="http2MaxFramePayloadSizeInBytes", alias="http2maxframepayloadsizeinbytes", optional=true)
    Integer http2MaxFramePayloadSizeInBytes;
    @Param(name="http2MaxHeaderListSizeInBytes", alias="http2maxheaderlistsizeinbytes", optional=true)
    Integer http2MaxHeaderListSizeInBytes;
    @Param(name="http2StreamsHighWaterMark", alias="http2streamshighwatermark", optional=true)
    Float http2StreamsHighWaterMark;
    @Param(name="http2CleanPercentage", alias="http2cleanpercentage", optional=true)
    Float http2CleanPercentage;
    @Param(name="http2CleanFrequencyCheck", alias="http2cleanfrequencycheck", optional=true)
    Integer http2CleanFrequencyCheck;
    @Param(name="http2DisableCipherCheck", alias="http2disableciphercheck", optional=true)
    Boolean http2DisableCipherCheck;
    @Param(name="http2PushEnabled", alias="http2pushenabled", optional=true)
    Boolean http2PushEnabled;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    ServiceLocator services;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        Target targetUtil = (Target)this.services.getService(Target.class, new Annotation[0]);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        ActionReport report = context.getActionReport();
        Protocols protocols = this.config.getNetworkConfig().getProtocols();
        Protocol protocol = null;
        for (Protocol p : protocols.getProtocol()) {
            if (!this.protocolName.equals(p.getName())) continue;
            protocol = p;
        }
        if (protocol == null) {
            report.setMessage(MessageFormat.format(rb.getString("AS-WEB-ADMIN-00013"), this.protocolName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (protocol.getHttp() != null) {
            report.setMessage(MessageFormat.format(rb.getString("AS-WEB-ADMIN-00015"), this.protocolName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocol>(){

                public Object run(Protocol param) throws TransactionFailure {
                    Http http = (Http)param.createChild(Http.class);
                    FileCache cache = (FileCache)http.createChild(FileCache.class);
                    cache.setEnabled("false");
                    http.setFileCache(cache);
                    http.setDefaultVirtualServer(CreateHttp.this.defaultVirtualServer);
                    http.setDnsLookupEnabled(CreateHttp.this.dnsLookupEnabled == null ? null : CreateHttp.this.dnsLookupEnabled.toString());
                    http.setMaxConnections(CreateHttp.this.maxConnections);
                    http.setRequestTimeoutSeconds(CreateHttp.this.requestTimeoutSeconds);
                    http.setTimeoutSeconds(CreateHttp.this.timeoutSeconds);
                    http.setXpoweredBy(CreateHttp.this.xPoweredBy == null ? null : CreateHttp.this.xPoweredBy.toString());
                    http.setServerHeader(CreateHttp.this.serverHeader == null ? null : CreateHttp.this.serverHeader.toString());
                    http.setXframeOptions(CreateHttp.this.xFrameOptions == null ? null : CreateHttp.this.xFrameOptions.toString());
                    http.setServerName(CreateHttp.this.serverName);
                    http.setHttp2Enabled(CreateHttp.this.http2Enabled.toString());
                    if (CreateHttp.this.http2MaxConcurrentStreams != null) {
                        http.setHttp2MaxConcurrentStreams(CreateHttp.this.http2MaxConcurrentStreams.toString());
                    }
                    if (CreateHttp.this.http2InitialWindowSizeInBytes != null) {
                        http.setHttp2InitialWindowSizeInBytes(CreateHttp.this.http2InitialWindowSizeInBytes.toString());
                    }
                    if (CreateHttp.this.http2MaxFramePayloadSizeInBytes != null) {
                        http.setHttp2MaxFramePayloadSizeInBytes(CreateHttp.this.http2MaxFramePayloadSizeInBytes.toString());
                    }
                    if (CreateHttp.this.http2MaxHeaderListSizeInBytes != null) {
                        http.setHttp2MaxHeaderListSizeInBytes(CreateHttp.this.http2MaxHeaderListSizeInBytes.toString());
                    }
                    if (CreateHttp.this.http2StreamsHighWaterMark != null) {
                        http.setHttp2StreamsHighWaterMark(CreateHttp.this.http2StreamsHighWaterMark.toString());
                    }
                    if (CreateHttp.this.http2CleanPercentage != null) {
                        http.setHttp2CleanPercentage(CreateHttp.this.http2CleanPercentage.toString());
                    }
                    if (CreateHttp.this.http2CleanFrequencyCheck != null) {
                        http.setHttp2CleanFrequencyCheck(CreateHttp.this.http2CleanFrequencyCheck.toString());
                    }
                    if (CreateHttp.this.http2DisableCipherCheck != null) {
                        http.setHttp2DisableCipherCheck(CreateHttp.this.http2DisableCipherCheck.toString());
                    }
                    if (CreateHttp.this.http2PushEnabled != null) {
                        http.setHttp2PushEnabled(CreateHttp.this.http2PushEnabled.toString());
                    }
                    param.setHttp(http);
                    return http;
                }
            }, (ConfigBeanProxy)protocol);
        }
        catch (TransactionFailure e) {
            report.setMessage(MessageFormat.format(rb.getString("AS-WEB-ADMIN-00014"), this.protocolName, e.getMessage() == null ? "No reason given." : e.getMessage()));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

