/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.mbean;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.glassfish.admin.amx.base.Pathnames;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.core.PathnameParser;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.core.proxy.AMXProxyHandler;
import org.glassfish.admin.amx.impl.mbean.AMXImplBase;
import org.glassfish.admin.amx.util.AMXLoggerInfo;
import org.glassfish.admin.amx.util.CollectionUtil;
import org.glassfish.admin.amx.util.ExceptionUtil;
import org.glassfish.admin.amx.util.ListUtil;
import org.glassfish.admin.amx.util.jmx.JMXUtil;
import org.glassfish.admin.amx.util.stringifier.SmartStringifier;

public final class PathnamesImpl
extends AMXImplBase {
    private static final int MAX_CACHE_SIZE = 1024;
    private final ConcurrentMap<String, ObjectName> mPathnameCache = new ConcurrentHashMap<String, ObjectName>();

    public PathnamesImpl(ObjectName parentObjectName) {
        super(parentObjectName, Pathnames.class);
    }

    public ObjectName resolvePath(String path) {
        ObjectName result = (ObjectName)this.mPathnameCache.get(path);
        if (result != null) {
            return result;
        }
        if (path.equals("/")) {
            return this.getDomainRoot();
        }
        PathnameParser parser = new PathnameParser(path);
        String parentPath = parser.parentPath();
        String props = Util.makeProp("pp", Util.quoteIfNeeded(parentPath));
        ObjectName pattern = JMXUtil.newObjectNamePattern(this.getObjectName().getDomain(), props);
        Set<ObjectName> s = this.getMBeanServer().queryNames(pattern, null);
        ObjectName objectName = null;
        String type = parser.type();
        String name = parser.name();
        for (ObjectName child : s) {
            boolean singleton;
            if (!type.equals(Util.getTypeProp(child))) continue;
            String nameProp = Util.getNameProp(child);
            if (nameProp == null) {
                if (name != null) continue;
                objectName = child;
                break;
            }
            if (name != null && name.equals(nameProp)) {
                objectName = child;
                break;
            }
            MBeanInfo mbeanInfo = this.getProxyFactory().getMBeanInfo(child);
            if (mbeanInfo == null || !(singleton = AMXProxyHandler.singleton(mbeanInfo)) || name != null) continue;
            objectName = child;
            break;
        }
        if (this.mPathnameCache.keySet().size() > 1024) {
            this.mPathnameCache.clear();
        }
        if (objectName != null) {
            this.mPathnameCache.put(path, objectName);
        }
        return objectName;
    }

    private AMXProxy resolveToProxy(String path) {
        ObjectName objectName = this.resolvePath(path);
        if (objectName == null) {
            return null;
        }
        return this.getProxyFactory().getProxy(objectName, AMXProxy.class);
    }

    public ObjectName[] resolvePaths(String[] paths) {
        ObjectName[] objectNames = new ObjectName[paths.length];
        int i = 0;
        for (String path : paths) {
            try {
                objectNames[i] = this.resolvePath(path);
            }
            catch (Exception e) {
                objectNames[i] = null;
            }
            ++i;
        }
        return objectNames;
    }

    public ObjectName[] ancestors(String path) {
        ObjectName objectName = this.resolvePath(path);
        if (objectName == null) {
            return null;
        }
        return this.ancestors(objectName);
    }

    public ObjectName[] ancestors(ObjectName mbean) {
        ArrayList<ObjectName> objectNames = new ArrayList<ObjectName>();
        MBeanServer server = this.getMBeanServer();
        ObjectName cur = mbean;
        while (cur != null) {
            objectNames.add(cur);
            cur = (ObjectName)JMXUtil.getAttribute(server, cur, "Parent");
        }
        List reversed = ListUtil.reverse(objectNames);
        ObjectName[] ancestors = new ObjectName[reversed.size()];
        reversed.toArray(ancestors);
        return ancestors;
    }

    private boolean isInstanceNotFound(Throwable t) {
        return ExceptionUtil.getRootCause(t) instanceof InstanceNotFoundException;
    }

    private void listChildren(AMXProxy top, List<AMXProxy> list, boolean recursive) {
        Set<AMXProxy> children = null;
        try {
            children = top.childrenSet();
            if (children == null) {
                return;
            }
        }
        catch (Exception e) {
            if (!this.isInstanceNotFound(e)) {
                AMXLoggerInfo.getLogger().log(Level.WARNING, "NCLS-COM-00040", new Object[]{top.objectName(), ExceptionUtil.getRootCause(e).getLocalizedMessage()});
            }
            return;
        }
        for (AMXProxy child : children) {
            try {
                list.add(child);
                if (!recursive) continue;
                this.listChildren(child, list, true);
            }
            catch (Exception e) {
                if (this.isInstanceNotFound(e)) continue;
                AMXLoggerInfo.getLogger().log(Level.WARNING, "NCLS-COM-00041", new Object[]{child.objectName(), ExceptionUtil.getRootCause(e).getLocalizedMessage()});
            }
        }
    }

    private List<AMXProxy> listChildren(String path, boolean recursive) {
        AMXProxy topProxy = this.resolveToProxy(path);
        if (topProxy == null) {
            return null;
        }
        ArrayList<AMXProxy> list = new ArrayList<AMXProxy>();
        this.listChildren(topProxy, list, recursive);
        return list;
    }

    public String[] getAllPathnames() {
        try {
            String[] allButRoot = this.listPaths("/", true);
            String[] all = new String[allButRoot.length + 1];
            all[0] = "/";
            System.arraycopy(allButRoot, 0, all, 1, allButRoot.length);
            return all;
        }
        catch (Throwable t) {
            AMXLoggerInfo.getLogger().log(Level.WARNING, "NCLS-COM-00042", ExceptionUtil.getRootCause(t).getLocalizedMessage());
            return new String[]{"/"};
        }
    }

    public ObjectName[] listObjectNames(String path, boolean recursive) {
        List<AMXProxy> list = this.listChildren(path, recursive);
        List<ObjectName> objectNames = Util.toObjectNameList(list);
        return CollectionUtil.toArray(objectNames, ObjectName.class);
    }

    public String[] listPaths(String path, boolean recursive) {
        List<AMXProxy> list = this.listChildren(path, recursive);
        ArrayList<String> paths = new ArrayList<String>();
        for (AMXProxy amx : list) {
            try {
                paths.add(amx.path());
            }
            catch (Exception e) {
                AMXLoggerInfo.getLogger().log(Level.WARNING, "NCLS-COM-00043", new Object[]{amx.objectName(), e.getLocalizedMessage()});
            }
        }
        return CollectionUtil.toArray(paths, String.class);
    }

    public String dump(String path) {
        ObjectName top = this.resolvePath(path);
        if (top == null) {
            return null;
        }
        AMXProxy topProxy = this.getProxyFactory().getProxy(top, AMXProxy.class);
        ArrayList<AMXProxy> list = new ArrayList<AMXProxy>();
        list.add(topProxy);
        this.listChildren(topProxy, list, true);
        String NL = "\n";
        StringBuilder buf = new StringBuilder();
        for (AMXProxy amx : list) {
            String p = amx.path();
            buf.append(p);
            buf.append("\n");
            Map<String, Object> attributesMap = amx.attributesMap();
            for (Map.Entry<String, Object> e : attributesMap.entrySet()) {
                buf.append("\t");
                buf.append(e.getKey());
                buf.append(" = ");
                buf.append(SmartStringifier.toString(e.getValue()));
                buf.append("\n");
            }
            buf.append("\n");
        }
        return buf.toString();
    }
}

